/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.tables;

import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.tables.TablePrefixStatementUpdater;
import org.jobrunr.utils.StringUtils;

public class OracleAndDB2TablePrefixStatementUpdater
implements TablePrefixStatementUpdater {
    private final String tablePrefix;

    public OracleAndDB2TablePrefixStatementUpdater(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Override
    public String updateStatement(String statement) {
        return statement.replace("jobrunr_", StorageProviderUtils.elementPrefixer(this.tablePrefix, "jobrunr_"));
    }

    @Override
    public String getSchema() {
        if (this.tablePrefix.contains(".")) {
            return StringUtils.substringBefore(this.tablePrefix, ".");
        }
        return null;
    }

    @Override
    public String getFQTableName(String tableName) {
        return StorageProviderUtils.elementPrefixer(this.tablePrefix, tableName);
    }
}

