/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.h2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.jobrunr.storage.sql.common.db.AnsiDialect;

public class H2Dialect
extends AnsiDialect {
    @Override
    public String escape(String toEscape) {
        return toEscape.replaceAll("(?<=[.\\s])value(?!\\S)", "`value`");
    }

    @Override
    public void setTimestamp(PreparedStatement ps, int i, Instant instant) throws SQLException {
        Instant roundedInstant = instant.plusNanos(500L).truncatedTo(ChronoUnit.MICROS);
        super.setTimestamp(ps, i, roundedInstant);
    }
}

