/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.mariadb;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import javax.sql.DataSource;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.DefaultSqlStorageProvider;
import org.jobrunr.storage.sql.common.db.AnsiDialect;
import org.jobrunr.storage.sql.common.db.Dialect;
import org.jobrunr.storage.sql.mariadb.MariaDbDialect;
import org.jobrunr.utils.exceptions.Exceptions;

public class MariaDbStorageProvider
extends DefaultSqlStorageProvider {
    public MariaDbStorageProvider(DataSource dataSource) {
        this(dataSource, StorageProviderUtils.DatabaseOptions.CREATE);
    }

    public MariaDbStorageProvider(DataSource dataSource, String tablePrefix) {
        this(dataSource, tablePrefix, StorageProviderUtils.DatabaseOptions.CREATE);
    }

    public MariaDbStorageProvider(DataSource dataSource, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(dataSource, (String)null, databaseOptions);
    }

    public MariaDbStorageProvider(DataSource dataSource, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        super(dataSource, MariaDbStorageProvider.getDialect(dataSource), tablePrefix, databaseOptions);
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        Exceptions.retryOnException(() -> super.announceBackgroundJobServer(serverStatus), 5);
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        return Exceptions.retryOnException(() -> super.removeTimedOutBackgroundJobServers(heartbeatOlderThan), 5);
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        return Exceptions.retryOnException(() -> super.signalBackgroundJobServerAlive(serverStatus), 5);
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        Exceptions.retryOnException(() -> super.signalBackgroundJobServerStopped(serverStatus), 5);
    }

    private static Dialect getDialect(DataSource dataSource) {
        MariaDbDialect mariaDbDialect;
        block9: {
            Connection connection = dataSource.getConnection();
            try {
                String url;
                String driverName = connection.getMetaData().getDriverName();
                int driverMajorVersion = connection.getMetaData().getDriverMajorVersion();
                int driverMinorVersion = connection.getMetaData().getDriverMinorVersion();
                if (driverName.toLowerCase().contains("mariadb") && driverMajorVersion >= 3 && driverMinorVersion < 2 && !(url = connection.getMetaData().getURL()).contains("useBulkStmts=false")) {
                    throw new IllegalStateException("JobRunr with a MariaDB Driver in range [3.0-3.2) requires a MariaDB connection with useBulkStmts=false as otherwise optimistic locking cannot be validated.");
                }
                String databaseProductName = connection.getMetaData().getDatabaseProductName();
                String databaseProductVersion = connection.getMetaData().getDatabaseProductVersion();
                mariaDbDialect = new MariaDbDialect(databaseProductName, databaseProductVersion);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    return new AnsiDialect();
                }
            }
            connection.close();
        }
        return mariaDbDialect;
    }
}

