/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils;

import java.util.Objects;
import java.util.Optional;
import org.jobrunr.utils.StringUtils;

public class VersionNumber
implements Comparable<VersionNumber> {
    public static final VersionNumber JAVA_VERSION = new VersionNumber(System.getProperty("java.version"));
    private final String completeVersion;
    private final String version;
    private final String majorVersion;
    private final String minorVersion;
    private final String patchVersion;
    private final String updateVersion;
    private final String qualifier;

    private VersionNumber(String completeVersion) {
        this.completeVersion = completeVersion;
        this.version = StringUtils.substringBefore(completeVersion, "-");
        this.qualifier = StringUtils.substringAfter(completeVersion, "-");
        String[] split = this.version.split("\\.");
        this.majorVersion = split.length > 0 ? split[0] : "0";
        this.minorVersion = split.length > 1 ? split[1] : "0";
        this.patchVersion = split.length > 2 ? StringUtils.substringBefore(split[2], "_") : "0";
        this.updateVersion = split.length > 2 ? Optional.ofNullable(StringUtils.substringAfter(split[2], "_")).orElse("0") : "0";
    }

    public String getCompleteVersion() {
        return this.completeVersion;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getPatchVersion() {
        return this.patchVersion;
    }

    public boolean isOlderOrEqualTo(VersionNumber versionNumber) {
        return this.equals(versionNumber) || this.isOlderThan(versionNumber);
    }

    public boolean isNewerOrEqualTo(VersionNumber versionNumber) {
        return this.equals(versionNumber) || this.isNewerThan(versionNumber);
    }

    public boolean hasMajorVersionHigherOrEqualTo(int majorVersion) {
        return this.hasMajorVersionHigherOrEqualTo(Integer.toString(majorVersion));
    }

    public boolean hasMajorVersionHigherOrEqualTo(String majorVersion) {
        return this.hasMajorVersionHigherOrEqualTo(new VersionNumber(majorVersion));
    }

    public boolean hasMajorVersionHigherOrEqualTo(VersionNumber o) {
        return this.compareVersionNumber(this.majorVersion, o.majorVersion) >= 0;
    }

    public boolean hasMajorAndMinorVersionHigherOrEqualTo(String majorAndMinorVersion) {
        return this.hasMajorAndMinorVersionHigherOrEqualTo(new VersionNumber(majorAndMinorVersion));
    }

    public boolean hasMajorAndMinorVersionHigherOrEqualTo(VersionNumber o) {
        if (this.compareVersionNumber(this.majorVersion, o.majorVersion) > 0) {
            return true;
        }
        return this.compareVersionNumber(this.majorVersion, o.majorVersion) == 0 && this.compareVersionNumber(this.minorVersion, o.minorVersion) >= 0;
    }

    public boolean hasMajorMinorAndPatchVersionHigherOrEqualTo(String majorMinorAndPatchVersion) {
        return this.hasMajorMinorAndPatchVersionHigherOrEqualTo(new VersionNumber(majorMinorAndPatchVersion));
    }

    public boolean hasMajorMinorAndPatchVersionHigherOrEqualTo(VersionNumber o) {
        if (this.compareVersionNumber(this.majorVersion, o.majorVersion) > 0) {
            return true;
        }
        if (this.compareVersionNumber(this.majorVersion, o.majorVersion) == 0 && this.compareVersionNumber(this.minorVersion, o.minorVersion) > 0) {
            return true;
        }
        return this.compareVersionNumber(this.majorVersion, o.majorVersion) == 0 && this.compareVersionNumber(this.minorVersion, o.minorVersion) == 0 && this.compareVersionNumber(this.patchVersion, o.patchVersion) >= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionNumber) {
            return this.completeVersion.equals(((VersionNumber)obj).completeVersion);
        }
        return false;
    }

    public boolean isOlderThan(Object obj) {
        if (obj instanceof VersionNumber) {
            return this.compareTo((VersionNumber)obj) < 0;
        }
        return false;
    }

    public boolean isNewerThan(Object obj) {
        return !this.isOlderThan(obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.completeVersion);
    }

    @Override
    public int compareTo(VersionNumber o) {
        int majorVersionComparison = this.compareVersionNumber(this.majorVersion, o.majorVersion);
        if (majorVersionComparison != 0) {
            return majorVersionComparison;
        }
        int minorVersionComparison = this.compareVersionNumber(this.minorVersion, o.minorVersion);
        if (minorVersionComparison != 0) {
            return minorVersionComparison;
        }
        int patchVersionComparison = this.compareVersionNumber(this.patchVersion, o.patchVersion);
        if (patchVersionComparison != 0) {
            return patchVersionComparison;
        }
        int updateVersionComparison = this.compareVersionNumber(this.updateVersion, o.updateVersion);
        if (updateVersionComparison != 0) {
            return updateVersionComparison;
        }
        if (StringUtils.isNullOrEmpty(this.qualifier) && StringUtils.isNullOrEmpty(o.qualifier)) {
            return 0;
        }
        if (StringUtils.isNullOrEmpty(this.qualifier) && StringUtils.isNotNullOrEmpty(o.qualifier)) {
            return 1;
        }
        if (StringUtils.isNotNullOrEmpty(this.qualifier) && StringUtils.isNullOrEmpty(o.qualifier)) {
            return -1;
        }
        return this.qualifier.compareTo(o.qualifier);
    }

    public String toString() {
        return this.completeVersion;
    }

    private int compareVersionNumber(String myself, String other) {
        if (myself.length() != other.length()) {
            return myself.length() - other.length();
        }
        if (myself.compareTo(other) < 0) {
            return -1;
        }
        if (myself.compareTo(other) > 0) {
            return 1;
        }
        return 0;
    }

    public static VersionNumber v(String version) {
        return new VersionNumber(version);
    }
}

