/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Function;
import java.util.function.Supplier;

public class Exceptions {
    public static boolean hasCause(Throwable t, Class<? extends Throwable> exceptionClass) {
        if (t.getClass().isAssignableFrom(exceptionClass)) {
            return true;
        }
        if (t.getCause() != null) {
            return Exceptions.hasCause(t.getCause(), exceptionClass);
        }
        return false;
    }

    public static String getStackTraceAsString(Throwable exception) {
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static <T> T retryOnException(Supplier<T> supplier, int maxRetries) {
        return Exceptions.retryOnException(supplier, maxRetries, 20L);
    }

    public static <T> T retryOnException(Supplier<T> supplier, int maxRetries, long timeSeed) {
        return Exceptions.retryOnException(supplier, (E e) -> true, maxRetries, timeSeed);
    }

    public static <T, E extends RuntimeException> T retryOnException(Supplier<T> supplier, Function<E, Boolean> retry, int maxRetries, long timeSeed) {
        int count = 0;
        while (count <= maxRetries) {
            try {
                Thread.sleep((long)count * timeSeed);
                return supplier.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException e) {
                RuntimeException exception = e;
                if (!retry.apply(exception).booleanValue()) {
                    throw e;
                }
                if (++count < maxRetries) continue;
                throw e;
            }
        }
        throw new IllegalStateException("Cannot happen");
    }

    public static void retryOnException(Runnable runnable, int maxRetries) {
        Exceptions.retryOnException(runnable, e -> true, maxRetries);
    }

    public static void retryOnException(Runnable runnable, int maxRetries, long timeSeed) {
        Exceptions.retryOnException(runnable, (E e) -> true, maxRetries, timeSeed);
    }

    public static <E extends RuntimeException> void retryOnException(Runnable runnable, Function<E, Boolean> retry, int maxRetries) {
        Exceptions.retryOnException(runnable, retry, maxRetries, 20L);
    }

    public static <E extends RuntimeException> void retryOnException(Runnable runnable, Function<E, Boolean> retry, int maxRetries, long timeSeed) {
        int count = 0;
        while (count <= maxRetries) {
            try {
                Thread.sleep((long)count * timeSeed);
                runnable.run();
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException e) {
                RuntimeException exception = e;
                if (!retry.apply(exception).booleanValue()) {
                    throw e;
                }
                if (++count < maxRetries) continue;
                throw e;
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }
}

