/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper;

import java.io.File;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.states.AbstractJobState;
import org.jobrunr.jobs.states.EnqueuedState;
import org.jobrunr.jobs.states.ProcessingState;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JsonMapperValidator {
    public static JsonMapper validateJsonMapper(JsonMapper jsonMapper) {
        try {
            String serializedJob = jsonMapper.serialize(JsonMapperValidator.getJobForTesting());
            JsonMapperValidator.testTimeFields(serializedJob);
            JsonMapperValidator.testUseFieldsNotMethods(serializedJob);
            JsonMapperValidator.testUsePolymorphism(serializedJob);
            JsonMapperValidator.testCanConvertBackToJob(jsonMapper, serializedJob);
            return jsonMapper;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The JsonMapper you provided cannot be used as it deserializes jobs in an incorrect way.", e);
        }
    }

    private static void testTimeFields(String serializedJob) {
        if (!serializedJob.contains("\"createdAt\":\"2021-10-14T22:00:00Z\"")) {
            throw new IllegalArgumentException("Timestamps are wrongly formatted for JobRunr. They should be in ISO8601 format.");
        }
    }

    private static void testUseFieldsNotMethods(String serializedJob) {
        if (serializedJob.contains("jobStates") && !serializedJob.contains("jobHistory")) {
            throw new IllegalArgumentException("Job Serialization should use fields and not getters/setters.");
        }
    }

    private static void testUsePolymorphism(String serializedJob) {
        if (!serializedJob.contains("\"@class\":\"org.jobrunr.jobs.states.ScheduledState\"")) {
            throw new IllegalArgumentException("Polymorphism is not supported as no @class annotation is present with fully qualified name of the different Job states.");
        }
    }

    private static void testCanConvertBackToJob(JsonMapper jsonMapper, String serializedJob) {
        try {
            jsonMapper.deserialize(serializedJob, Job.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The JsonMapper cannot convert jobs from Json.", e);
        }
    }

    private static <T extends AbstractJobState> T setCreatedAndScheduledDates(T jobState, Instant createdAt, Instant scheduledAt) {
        JsonMapperValidator.setCreatedAt(jobState, createdAt);
        JsonMapperValidator.setField(jobState, "scheduledAt", scheduledAt);
        return jobState;
    }

    private static <T extends AbstractJobState> T setCreatedAt(T jobState, Instant instant) {
        JsonMapperValidator.setField(jobState, "createdAt", instant);
        return jobState;
    }

    private static <T extends AbstractJobState> T setField(T jobState, String fieldname, Instant instant) {
        ReflectionUtils.setFieldUsingAutoboxing(fieldname, jobState, (Object)instant);
        return jobState;
    }

    private static Job getJobForTesting() {
        Job job = new Job(UUID.randomUUID(), 5, new JobDetails("java.lang.System", "out", "println", Collections.singletonList(new JobParameter("java.io.File", (Object)new File("/tmp/")))), Arrays.asList(JsonMapperValidator.setCreatedAndScheduledDates(new ScheduledState(Instant.now()), Instant.ofEpochSecond(1634248800L), Instant.ofEpochSecond(1634245200L)), JsonMapperValidator.setCreatedAt(new EnqueuedState(), Instant.ofEpochSecond(1634248800L)), JsonMapperValidator.setCreatedAt(new ProcessingState(UUID.fromString("117bbfcf-e6df-45f0-82a7-b88fd8f96c06"), "some host name"), Instant.ofEpochSecond(1634248900L))), new ConcurrentHashMap<String, Object>());
        job.setJobName("Some name");
        return job;
    }
}

