/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.jobs.states.JobState;
import org.jobrunr.utils.JarUtils;
import org.jobrunr.utils.mapper.JobParameterJsonMapperException;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.gson.ClassNameObjectTypeAdapter;
import org.jobrunr.utils.mapper.gson.DurationAdapter;
import org.jobrunr.utils.mapper.gson.FileAdapter;
import org.jobrunr.utils.mapper.gson.InstantAdapter;
import org.jobrunr.utils.mapper.gson.JobParameterDeserializer;
import org.jobrunr.utils.mapper.gson.LocalDateAdapter;
import org.jobrunr.utils.mapper.gson.LocalDateTimeAdapter;
import org.jobrunr.utils.mapper.gson.OffsetDateTimeAdapter;
import org.jobrunr.utils.mapper.gson.PathAdapter;
import org.jobrunr.utils.mapper.gson.RuntimeClassNameTypeAdapterFactory;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class GsonJsonMapper
implements JsonMapper {
    private final Gson gson;

    public GsonJsonMapper() {
        this(new GsonBuilder());
    }

    public GsonJsonMapper(GsonBuilder gsonBuilder) {
        this.gson = this.initGson(gsonBuilder);
        this.fixGsonNotBeingExtensible(this.gson);
    }

    public GsonJsonMapper(Gson gson) {
        this.gson = gson;
        this.fixGsonNotBeingExtensible(gson);
    }

    protected Gson initGson(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapterFactory(RuntimeClassNameTypeAdapterFactory.of(JobState.class)).registerTypeAdapterFactory(RuntimeClassNameTypeAdapterFactory.of(Map.class)).registerTypeAdapterFactory(RuntimeClassNameTypeAdapterFactory.of(JobContext.Metadata.class)).registerTypeHierarchyAdapter(Path.class, (Object)new PathAdapter().nullSafe()).registerTypeAdapter(File.class, (Object)new FileAdapter().nullSafe()).registerTypeAdapter(Instant.class, (Object)new InstantAdapter().nullSafe()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter().nullSafe()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter().nullSafe()).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeAdapter().nullSafe()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(JobParameter.class, (Object)new JobParameterDeserializer()).create();
    }

    @Override
    public String serialize(Object object) {
        try {
            return this.gson.toJson(object);
        }
        catch (Exception e) {
            throw new JobParameterJsonMapperException("The job parameters are not serializable.", e);
        }
    }

    @Override
    public void serialize(OutputStream outputStream, Object object) {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            this.gson.toJson(object, (Appendable)writer);
        }
        catch (IOException e) {
            throw JobRunrException.shouldNotHappenException(e);
        }
    }

    @Override
    public <T> T deserialize(String serializedObjectAsString, Class<T> clazz) {
        return (T)this.gson.fromJson(serializedObjectAsString, clazz);
    }

    private void fixGsonNotBeingExtensible(Gson gson) {
        try {
            Field factories = ReflectionUtils.getField(Gson.class, "factories");
            ReflectionUtils.makeAccessible(factories);
            ArrayList<TypeAdapterFactory> o = new ArrayList<TypeAdapterFactory>((Collection)factories.get(gson));
            if (!o.get(1).getClass().getName().contains("ObjectTypeAdapter")) {
                throw JobRunrException.shouldNotHappenException(String.format("It looks like you are running a Gson version (%s) which is not compatible with JobRunr", JarUtils.getVersion(Gson.class)));
            }
            o.set(1, ClassNameObjectTypeAdapter.FACTORY);
            factories.set(gson, Collections.unmodifiableList(o));
        }
        catch (ReflectiveOperationException e) {
            throw JobRunrException.shouldNotHappenException(e);
        }
    }
}

