/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;

public class NullSafeJsonBuilder
implements JsonObjectBuilder {
    private final JsonObjectBuilder delegate;

    public static NullSafeJsonBuilder nullSafeJsonObjectBuilder() {
        return new NullSafeJsonBuilder();
    }

    public static NullSafeJsonBuilder nullSafeJsonObjectBuilder(Jsonb jsonb, Object object) {
        String asJson = jsonb.toJson(object);
        JsonObject jsonObject = Json.createObjectBuilder((JsonObject)((JsonObject)jsonb.fromJson(asJson, JsonObject.class))).build();
        return new NullSafeJsonBuilder(jsonObject);
    }

    public static NullSafeJsonBuilder nullSafeJsonObjectBuilder(JsonObject jsonObject) {
        return new NullSafeJsonBuilder(jsonObject);
    }

    public NullSafeJsonBuilder() {
        this.delegate = Json.createObjectBuilder();
    }

    public NullSafeJsonBuilder(JsonObject object) {
        this.delegate = Json.createObjectBuilder((JsonObject)object);
    }

    public NullSafeJsonBuilder add(String name, JsonValue value) {
        if (value != null) {
            this.delegate.add(name, value);
        }
        return this;
    }

    public NullSafeJsonBuilder add(String name, String value) {
        if (value != null) {
            this.delegate.add(name, value);
        }
        return this;
    }

    public NullSafeJsonBuilder add(String name, UUID value) {
        if (value != null) {
            this.delegate.add(name, value.toString());
        }
        return this;
    }

    public NullSafeJsonBuilder add(String name, BigInteger value) {
        if (value != null) {
            this.delegate.add(name, value);
        }
        return this;
    }

    public NullSafeJsonBuilder add(String name, BigDecimal value) {
        if (value != null) {
            this.delegate.add(name, value);
        }
        return this;
    }

    public NullSafeJsonBuilder add(String name, int value) {
        this.delegate.add(name, value);
        return this;
    }

    public NullSafeJsonBuilder add(String name, Integer value) {
        if (value != null) {
            this.add(name, (int)value);
        }
        return this;
    }

    public NullSafeJsonBuilder add(String name, Long value) {
        if (value != null) {
            this.add(name, (long)value);
        }
        return this;
    }

    public NullSafeJsonBuilder add(String name, long value) {
        this.delegate.add(name, value);
        return this;
    }

    public NullSafeJsonBuilder add(String name, double value) {
        this.delegate.add(name, value);
        return this;
    }

    public NullSafeJsonBuilder add(String name, boolean value) {
        this.delegate.add(name, value);
        return this;
    }

    public NullSafeJsonBuilder addNull(String name) {
        this.delegate.addNull(name);
        return this;
    }

    public NullSafeJsonBuilder add(String name, JsonObjectBuilder builder) {
        if (builder != null) {
            this.delegate.add(name, builder);
        }
        return this;
    }

    public NullSafeJsonBuilder add(String name, JsonArrayBuilder builder) {
        if (builder != null) {
            this.delegate.add(name, builder);
        }
        return this;
    }

    public JsonObject build() {
        return this.delegate.build();
    }
}

