/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb.adapters;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.bind.adapter.JsonbAdapter;
import java.util.ArrayList;
import java.util.List;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.JobParameterNotDeserializableException;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.utils.mapper.JobParameterJsonMapperException;
import org.jobrunr.utils.mapper.JsonMapperUtils;
import org.jobrunr.utils.mapper.jsonb.JobRunrJsonb;
import org.jobrunr.utils.mapper.jsonb.NullSafeJsonBuilder;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobDetailsAdapter
implements JsonbAdapter<JobDetails, JsonObject> {
    private final JobRunrJsonb jsonb;

    public JobDetailsAdapter(JobRunrJsonb jsonb) {
        this.jsonb = jsonb;
    }

    public JsonObject adaptToJson(JobDetails jobDetails) throws Exception {
        JsonArrayBuilder parametersJsonArray = Json.createArrayBuilder();
        try {
            for (JobParameter jobState : jobDetails.getJobParameters()) {
                JsonObject object = NullSafeJsonBuilder.nullSafeJsonObjectBuilder(this.jsonb, jobState).build();
                parametersJsonArray.add((JsonValue)object);
            }
        }
        catch (Exception e) {
            throw new JobParameterJsonMapperException("The job parameters are not serializable.", e);
        }
        return NullSafeJsonBuilder.nullSafeJsonObjectBuilder().add("cacheable", jobDetails.getCacheable()).add("className", jobDetails.getClassName()).add("staticFieldName", jobDetails.getStaticFieldName()).add("methodName", jobDetails.getMethodName()).add("jobParameters", (JsonValue)parametersJsonArray.build()).build();
    }

    public JobDetails adaptFromJson(JsonObject jsonObject) throws Exception {
        JobDetails jobDetails = new JobDetails(jsonObject.getString("className"), jsonObject.containsKey((Object)"staticFieldName") ? (jsonObject.isNull("staticFieldName") ? null : jsonObject.getString("staticFieldName")) : null, jsonObject.getString("methodName"), this.getJobDetailsParameters(jsonObject.getJsonArray("jobParameters")));
        jobDetails.setCacheable(jsonObject.getBoolean("cacheable"));
        return jobDetails;
    }

    private List<JobParameter> getJobDetailsParameters(JsonArray jobParameters) {
        ArrayList<JobParameter> result = new ArrayList<JobParameter>();
        for (JsonValue jsonValue : jobParameters) {
            JsonObject jsonObject = jsonValue.asJsonObject();
            String methodClassName = jsonObject.getString("className");
            String actualClassName = jsonObject.getString("actualClassName", null);
            try {
                Class objectClass = ReflectionUtils.toClass(JsonMapperUtils.getActualClassName(methodClassName, actualClassName));
                if (JobContext.class.equals(objectClass)) {
                    result.add(new JobParameter(methodClassName, (Object)JobContext.Null));
                    continue;
                }
                Object object = this.jsonb.fromJsonValue((JsonValue)jsonObject.get((Object)"object"), objectClass);
                result.add(new JobParameter(methodClassName, object));
            }
            catch (Exception e) {
                result.add(new JobParameter(new JobParameterNotDeserializableException(JsonMapperUtils.getActualClassName(methodClassName, actualClassName), e.getMessage())));
            }
        }
        return result;
    }
}

