/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb.adapters;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.bind.adapter.JsonbAdapter;
import java.util.ArrayList;
import java.util.List;
import org.jobrunr.jobs.states.JobState;
import org.jobrunr.utils.mapper.jsonb.JobRunrJsonb;
import org.jobrunr.utils.mapper.jsonb.NullSafeJsonBuilder;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobHistoryAdapter
implements JsonbAdapter<List<JobState>, JsonArray> {
    private final JobRunrJsonb jsonb;

    public JobHistoryAdapter(JobRunrJsonb jsonb) {
        this.jsonb = jsonb;
    }

    public JsonArray adaptToJson(List<JobState> jobStates) {
        JsonArrayBuilder historyJsonObject = Json.createArrayBuilder();
        for (JobState jobState : jobStates) {
            JsonObject jsonObject = NullSafeJsonBuilder.nullSafeJsonObjectBuilder(this.jsonb, jobState).add("@class", jobState.getClass().getName()).build();
            historyJsonObject.add((JsonValue)jsonObject);
        }
        return historyJsonObject.build();
    }

    public List<JobState> adaptFromJson(JsonArray jsonArray) {
        ArrayList<JobState> result = new ArrayList<JobState>();
        for (JsonValue jsonValue : jsonArray) {
            JsonObject jsonObject = jsonValue.asJsonObject();
            String className = jsonObject.getString("@class");
            result.add((JobState)this.jsonb.fromJsonValue((JsonValue)jsonObject, ReflectionUtils.toClass(className)));
        }
        return result;
    }
}

