/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb.adapters;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.adapter.JsonbAdapter;
import java.util.Set;
import java.util.TreeSet;
import org.jobrunr.utils.mapper.jsonb.JobRunrJsonb;

public class JobLabelsAdapter
implements JsonbAdapter<Set<String>, JsonArray> {
    private final JobRunrJsonb jsonb;

    public JobLabelsAdapter(JobRunrJsonb jsonb) {
        this.jsonb = jsonb;
    }

    public JsonArray adaptToJson(Set<String> labels) {
        JsonArrayBuilder historyJsonObject = Json.createArrayBuilder();
        for (String label : labels) {
            historyJsonObject.add(label);
        }
        return historyJsonObject.build();
    }

    public Set<String> adaptFromJson(JsonArray jsonArray) {
        TreeSet<String> result = new TreeSet<String>();
        if (jsonArray != null) {
            for (JsonValue jsonValue : jsonArray) {
                result.add(((JsonString)jsonValue).getString());
            }
        }
        return result;
    }
}

