/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb.adapters;

import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.adapter.JsonbAdapter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jobrunr.utils.mapper.jsonb.JobRunrJsonb;
import org.jobrunr.utils.mapper.jsonb.NullSafeJsonBuilder;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobMetadataAdapter
implements JsonbAdapter<Map<String, Object>, JsonObject> {
    private final JobRunrJsonb jsonb;

    public JobMetadataAdapter(JobRunrJsonb jsonb) {
        this.jsonb = jsonb;
    }

    public JsonObject adaptToJson(Map<String, Object> map) {
        JsonObjectBuilder metadataJsonObjectBuilder = Json.createObjectBuilder().add("@class", "java.util.concurrent.ConcurrentHashMap");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object object = entry.getValue();
            JsonValue jsonValue = this.jsonb.fromJsonToJsonValue(object);
            if (JsonValue.ValueType.OBJECT.equals((Object)jsonValue.getValueType())) {
                NullSafeJsonBuilder childObjectBuilder = NullSafeJsonBuilder.nullSafeJsonObjectBuilder((JsonObject)jsonValue).add("@class", object.getClass().getName());
                metadataJsonObjectBuilder.add(key, (JsonObjectBuilder)childObjectBuilder);
                continue;
            }
            if (JsonValue.ValueType.ARRAY.equals((Object)jsonValue.getValueType())) {
                throw new UnsupportedOperationException("Not supported: " + jsonValue.getValueType());
            }
            metadataJsonObjectBuilder.add(key, jsonValue);
        }
        return metadataJsonObjectBuilder.build();
    }

    public ConcurrentHashMap<String, Object> adaptFromJson(JsonObject jsonMetadataObject) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (Map.Entry entry : jsonMetadataObject.entrySet()) {
            String key = (String)entry.getKey();
            if ("@class".equals(key)) continue;
            JsonValue jsonValue = (JsonValue)entry.getValue();
            if (JsonValue.ValueType.OBJECT.equals((Object)jsonValue.getValueType())) {
                JsonObject jsonObject = jsonValue.asJsonObject();
                Object o = this.jsonb.fromJsonValue((JsonValue)jsonObject, ReflectionUtils.toClass(jsonObject.getString("@class")));
                result.put(key, o);
                continue;
            }
            if (JsonValue.ValueType.STRING.equals((Object)jsonValue.getValueType())) {
                result.put(key, ((JsonString)jsonValue).getString());
                continue;
            }
            if (JsonValue.ValueType.NUMBER.equals((Object)jsonValue.getValueType())) {
                Number number = ((JsonNumber)jsonValue).numberValue();
                result.put(key, number.doubleValue());
                continue;
            }
            if (JsonValue.ValueType.TRUE.equals((Object)jsonValue.getValueType())) {
                result.put(key, true);
                continue;
            }
            if (!JsonValue.ValueType.FALSE.equals((Object)jsonValue.getValueType())) continue;
            result.put(key, false);
        }
        return result;
    }
}

