/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.reflection.autobox;

import java.math.BigDecimal;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.reflection.autobox.TypeAutoboxer;

public class IntegerTypeAutoboxer
implements TypeAutoboxer<Integer> {
    @Override
    public boolean supports(Class<?> type) {
        return Integer.TYPE.equals(type) || Integer.class.equals(type);
    }

    @Override
    public Integer autobox(Object value, Class<Integer> type) {
        if (value instanceof Integer) {
            return (Integer)ReflectionUtils.cast(value);
        }
        if (value instanceof BigDecimal) {
            return (Integer)ReflectionUtils.cast(((BigDecimal)value).intValue());
        }
        if (value instanceof String) {
            return (Integer)ReflectionUtils.cast(Integer.valueOf((String)value));
        }
        if (value instanceof Long) {
            return (Integer)ReflectionUtils.cast(((Long)value).intValue());
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Integer.class.getName()));
    }
}

