/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.resources;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jobrunr.utils.resources.PathFileSystemProvider;

public class VfsFilesystemProvider
extends PathFileSystemProvider {
    public static final String SCHEME = "vfs://";
    private final Set<Path> extractedFiles = new HashSet<Path>();

    @Override
    public Path toPath(URI uri) throws IOException {
        uri = URI.create(uri.toString().substring(SCHEME.length()));
        Path path = super.toPath(uri);
        this.extractedFiles.add(path);
        return path;
    }

    @Override
    public void close() throws IOException {
        for (Path path : this.extractedFiles) {
            Stream<Path> filesToDelete = Files.walk(path, new FileVisitOption[0]);
            try {
                filesToDelete.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            finally {
                if (filesToDelete == null) continue;
                filesToDelete.close();
            }
        }
        super.close();
    }
}

