/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.uuid;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static long toNumber(byte[] bytes) {
        return ByteUtil.toNumber(bytes, 0, bytes.length);
    }

    public static long toNumber(byte[] bytes, int start, int end) {
        long result = 0L;
        for (int i = start; i < end; ++i) {
            result = result << 8 | (long)bytes[i] & 0xFFL;
        }
        return result;
    }

    public static String toHexadecimal(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            chars[j] = ByteUtil.toHexChar(v >>> 4);
            chars[j + 1] = ByteUtil.toHexChar(v & 0xF);
            ++i;
            j += 2;
        }
        return new String(chars);
    }

    private static char toHexChar(int number) {
        if (number >= 0 && number <= 9) {
            return (char)(48 + number);
        }
        if (number >= 10 && number <= 15) {
            return (char)(87 + number);
        }
        return '\u0000';
    }
}

