/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.uuid;

import java.time.Clock;
import java.util.Random;
import java.util.UUID;
import java.util.function.LongSupplier;
import org.jobrunr.utils.uuid.ByteUtil;

public final class UUIDv7Factory {
    private static final int INCREMENT_TYPE_DEFAULT = 0;
    private static final int INCREMENT_TYPE_PLUS_1 = 1;
    private static final int INCREMENT_TYPE_PLUS_N = 2;
    static final int CLOCK_DRIFT_TOLERANCE = 10000;
    private final Clock clock;
    private final int incrementType;
    private final LongSupplier incrementSupplier;
    private final Random random;
    private final long versionMask;
    private UUID lastUuid;

    public UUIDv7Factory() {
        this(UUIDv7Factory.builder());
    }

    public UUIDv7Factory(Clock clock) {
        this(UUIDv7Factory.builder().withClock(clock));
    }

    public UUIDv7Factory(Builder builder) {
        this.clock = builder.getClock();
        this.incrementType = builder.getIncrementType();
        this.incrementSupplier = builder.getIncrementSupplier();
        this.random = new Random();
        this.versionMask = 28672L;
        this.lastUuid = this.make(this.clock.millis(), this.random.nextLong(), this.random.nextLong());
    }

    public static Builder builder() {
        return new Builder();
    }

    public synchronized UUID create() {
        long lastTime;
        long time = this.clock.millis();
        if (time > (lastTime = this.lastUuid.getMostSignificantBits() >>> 16) - 10000L && time <= lastTime) {
            this.lastUuid = this.increment(this.lastUuid);
        } else {
            long long1 = this.random.nextLong();
            long long2 = this.random.nextLong();
            this.lastUuid = this.make(time, long1, long2);
        }
        return this.copy(this.lastUuid);
    }

    private synchronized UUID increment(UUID uuid) {
        long overflow = 0L;
        long versionMask = 61440L;
        long variantMask = -4611686018427387904L;
        long msb = uuid.getMostSignificantBits() | 0xF000L;
        long lsb = (uuid.getLeastSignificantBits() | 0xC000000000000000L) + this.incrementSupplier.getAsLong();
        if (0 == this.incrementType) {
            long clearMask = -281474976710656L;
            if ((lsb & 0xFFFF000000000000L) == 0L) {
                ++msb;
            }
            byte[] bytes = new byte[6];
            this.random.nextBytes(bytes);
            lsb &= 0xFFFF000000000000L;
            lsb |= ByteUtil.toNumber(bytes);
        } else if (lsb == 0L) {
            ++msb;
        }
        return this.toUuid(msb, lsb);
    }

    private UUID make(long time, long long1, long long2) {
        return this.toUuid(time << 16 | long1 & 0xFFFFL, long2);
    }

    private synchronized UUID copy(UUID uuid) {
        return this.toUuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private UUID toUuid(long msb, long lsb) {
        long msb0 = msb & 0xFFFFFFFFFFFF0FFFL | this.versionMask;
        long lsb0 = lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb0, lsb0);
    }

    public static class Builder {
        protected static final Clock DEFAULT_CLOCK = Clock.systemUTC();
        protected Clock clock;
        protected Random random;
        private Integer incrementType = 0;
        private Long incrementMax;

        protected Clock getClock() {
            if (this.clock == null) {
                this.clock = DEFAULT_CLOCK;
            }
            return this.clock;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withIncrementPlus1() {
            this.incrementType = 1;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN() {
            this.incrementType = 2;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN(long incrementMax) {
            this.incrementType = 2;
            this.incrementMax = incrementMax;
            return this;
        }

        protected int getIncrementType() {
            return this.incrementType;
        }

        protected LongSupplier getIncrementSupplier() {
            switch (this.getIncrementType()) {
                case 1: {
                    return () -> 1L;
                }
                case 2: {
                    if (this.incrementMax == null) {
                        return () -> (this.random.nextLong() >>> 32) + 1L;
                    }
                    long positive = Long.MAX_VALUE;
                    return () -> (this.random.nextLong() & Long.MAX_VALUE) % this.incrementMax + 1L;
                }
            }
            return () -> 0x1000000000000L;
        }

        public UUIDv7Factory build() {
            return new UUIDv7Factory(this);
        }
    }
}

