/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Fields;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.SelectField;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.AutoAlias;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldAlias;
import org.jooq.impl.Multiset;
import org.jooq.impl.Names;
import org.jooq.impl.RowAsField;
import org.jooq.impl.Tools;

abstract class AbstractRowAsField<R extends Record>
extends AbstractField<R>
implements AutoAlias<SelectField<R>> {
    AbstractRowAsField(Name name, DataType<R> type) {
        super(name, type);
    }

    abstract Fields fields0();

    abstract Class<R> getRecordType();

    final AbstractRow<R> emulatedFields(Configuration configuration) {
        return Tools.row0(Tools.map(this.fields0().fields(), x -> x.as(Tools.sanitiseName(configuration, this.getUnqualifiedName().unquotedName() + configuration.settings().getNamePathSeparator() + x.getName())), Field[]::new));
    }

    @Override
    final int projectionSize() {
        int result = 0;
        for (Field<?> field : this.fields0().fields()) {
            result += ((AbstractField)field).projectionSize();
        }
        return result;
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (AbstractRowAsField.forceMultisetContent(ctx, () -> this.getDataType().getRow().size() > 1)) {
            AbstractRowAsField.acceptMultisetContent(ctx, this.getDataType().getRow(), this, this::acceptDefault);
        } else {
            this.acceptDefault(ctx);
        }
    }

    static final boolean forceMultisetContent(Context<?> ctx, BooleanSupplier degreeCheck) {
        return Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT)) || ctx.subquery() && RowAsField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect()) && !ctx.predicandSubquery() && !ctx.derivedTableSubquery() && !ctx.setOperationSubquery() && degreeCheck.getAsBoolean();
    }

    static final boolean forceRowContent(Context<?> ctx) {
        return Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_ROW_CONTENT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final void acceptMultisetContent(Context<?> ctx, Row row, Field<?> field, Consumer<? super Context<?>> acceptDefault) {
        Object previous = ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT);
        try {
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true);
            Name alias = field.getUnqualifiedName();
            switch (Tools.emulateMultiset(ctx.configuration())) {
                case JSON: {
                    switch (ctx.family()) {
                        default: 
                    }
                    ctx.visit(AbstractRowAsField.alias(ctx, alias, Multiset.returningClob(ctx, DSL.jsonArray(row.fields()).nullOnNull())));
                    return;
                }
                case JSONB: {
                    switch (ctx.family()) {
                        default: 
                    }
                    ctx.visit(AbstractRowAsField.alias(ctx, alias, Multiset.returningClob(ctx, DSL.jsonbArray(row.fields()).nullOnNull())));
                    return;
                }
                case XML: {
                    switch (ctx.family()) {
                        default: 
                    }
                    ctx.visit(AbstractRowAsField.alias(ctx, alias, DSL.xmlelement(Names.N_RECORD, Tools.map(row.fields(), (f, i) -> DSL.xmlelement(Tools.fieldNameString(i), f)))));
                    return;
                }
                default: {
                    acceptDefault.accept(ctx);
                    return;
                }
            }
        }
        finally {
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, previous);
        }
    }

    @Override
    public final SelectField<R> autoAlias(Context<?> ctx, SelectField<R> s) {
        if (RowAsField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect())) {
            return s;
        }
        if (AbstractRowAsField.forceMultisetContent(ctx, () -> this.getDataType().getRow().size() > 1)) {
            return s;
        }
        return new FieldAlias<R>(DSL.field(s), this.getUnqualifiedName());
    }

    private static final Field<?> alias(Context<?> ctx, Name alias, Field<?> field) {
        return ctx.declareFields() ? field.as(alias) : field;
    }

    abstract void acceptDefault(Context<?> var1);
}

