/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jooq.Binding;
import org.jooq.Check;
import org.jooq.Converter;
import org.jooq.ConverterContext;
import org.jooq.DataType;
import org.jooq.Domain;
import org.jooq.EmbeddableRecord;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.ParamMode;
import org.jooq.Parameter;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Support;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.CheckImpl;
import org.jooq.impl.Convert;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBinding;
import org.jooq.impl.DefaultConverterContext;
import org.jooq.impl.DomainImpl;
import org.jooq.impl.EmbeddableTableField;
import org.jooq.impl.IAdd;
import org.jooq.impl.IDiv;
import org.jooq.impl.IMul;
import org.jooq.impl.ISub;
import org.jooq.impl.IdentityImpl;
import org.jooq.impl.IndexImpl;
import org.jooq.impl.Lazy;
import org.jooq.impl.Neg;
import org.jooq.impl.ParameterImpl;
import org.jooq.impl.ReferenceImpl;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.UniqueKeyImpl;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@org.jooq.Internal
public final class Internal {
    private static final Lazy<ConverterContext> CONVERTER_SCOPE = Lazy.of(() -> new DefaultConverterContext(Tools.CONFIG.get()));
    private static final Lazy<Integer> JAVA_VERSION = Lazy.of(() -> {
        try {
            return (Integer)Reflect.onClass(Runtime.class).call("version").call("feature").get();
        }
        catch (ReflectException e) {
            return 8;
        }
    });

    @SafeVarargs
    @NotNull
    public static final <R extends Record, E extends EmbeddableRecord<E>> TableField<R, E> createEmbeddable(Name name, Class<E> recordType, Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createEmbeddable(name, recordType, false, table, fields);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record, E extends EmbeddableRecord<E>> TableField<R, E> createEmbeddable(Name name, Class<E> recordType, boolean replacesFields, Table<R> table, TableField<R, ?> ... fields) {
        return new EmbeddableTableField<R, E>(name, recordType, replacesFields, table, fields);
    }

    @NotNull
    public static final Index createIndex(Name name, Table<?> table, OrderField<?>[] sortFields, boolean unique) {
        return new IndexImpl(name, table, sortFields, null, unique);
    }

    @NotNull
    public static final <R extends Record, T> Identity<R, T> createIdentity(Table<R> table, TableField<R, T> field) {
        return new IdentityImpl<R, T>(table, field);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, (Name)null, fields, true);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, name, fields, true);
    }

    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ?>[] fields, boolean enforced) {
        return new UniqueKeyImpl<R>(table, name, fields, enforced);
    }

    @NotNull
    public static final <R extends Record, ER extends EmbeddableRecord<ER>> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ER> embeddableField, boolean enforced) {
        return Internal.createUniqueKey(table, name, Internal.fields(embeddableField), enforced);
    }

    @Deprecated
    @SafeVarargs
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createForeignKey(table, (Name)null, fields, key, key.getFieldsArray(), true);
    }

    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(Table<R> table, Name name, TableField<R, ?>[] fkFields, UniqueKey<U> uk, TableField<U, ?>[] ukFields, boolean enforced) {
        ReferenceImpl<R, Object> result = new ReferenceImpl<R, Object>(table, name, fkFields, uk, ukFields == null ? uk.getFieldsArray() : ukFields, enforced);
        if (uk instanceof UniqueKeyImpl) {
            UniqueKeyImpl u = (UniqueKeyImpl)uk;
            u.references.add(result);
        }
        return result;
    }

    @NotNull
    public static final <R extends Record, U extends Record, ER extends EmbeddableRecord<ER>> ForeignKey<R, U> createForeignKey(Table<R> table, Name name, TableField<R, ER> fkEmbeddableField, UniqueKey<U> uk, TableField<U, ER> ukEmbeddableField, boolean enforced) {
        return Internal.createForeignKey(table, name, Internal.fields(fkEmbeddableField), uk, Internal.fields(ukEmbeddableField), enforced);
    }

    @NotNull
    public static final <T extends Number> Sequence<T> createSequence(String name, Schema schema, DataType<T> type) {
        return new SequenceImpl<T>(name, schema, type, false);
    }

    @NotNull
    public static final <T extends Number> Sequence<T> createSequence(String name, Schema schema, DataType<T> type, Number startWith, Number incrementBy, Number minvalue, Number maxvalue, boolean cycle, Number cache) {
        return new SequenceImpl<T>(DSL.name(name), schema, type, false, startWith != null ? Tools.field((Object)startWith, type) : null, incrementBy != null ? Tools.field((Object)incrementBy, type) : null, minvalue != null ? Tools.field((Object)minvalue, type) : null, maxvalue != null ? Tools.field((Object)maxvalue, type) : null, cycle, cache != null ? Tools.field((Object)cache, type) : null);
    }

    @NotNull
    public static final <R extends Record> Check<R> createCheck(Table<R> table, Name name, String condition) {
        return Internal.createCheck(table, name, condition, true);
    }

    @NotNull
    public static final <R extends Record> Check<R> createCheck(Table<R> table, Name name, String condition, boolean enforced) {
        return new CheckImpl<R>(table, name, DSL.condition(condition), enforced);
    }

    @NotNull
    public static final <T> Domain<T> createDomain(Schema schema, Name name, DataType<T> type, Check<?> ... checks) {
        return Internal.createDomain(schema, name, type, null, null, checks);
    }

    @NotNull
    public static final <T, U> Domain<U> createDomain(Schema schema, Name name, DataType<T> type, Converter<T, U> converter, Check<?> ... checks) {
        return Internal.createDomain(schema, name, type, converter, null, checks);
    }

    @NotNull
    public static final <T, U> Domain<U> createDomain(Schema schema, Name name, DataType<T> type, Binding<T, U> binding, Check<?> ... checks) {
        return Internal.createDomain(schema, name, type, null, binding, checks);
    }

    @NotNull
    public static final <T, X, U> Domain<U> createDomain(Schema schema, Name name, DataType<T> type, Converter<X, U> converter, Binding<T, X> binding, Check<?> ... checks) {
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        return new DomainImpl<T>(schema, name, actualType, checks);
    }

    @NotNull
    public static final Name createPathAlias(Table<?> child, ForeignKey<?, ?> path) {
        Name name = DSL.name(path.getName());
        if (child instanceof TableImpl) {
            TableImpl t = (TableImpl)child;
            Table<?> ancestor = t.child;
            name = ancestor != null ? Internal.createPathAlias(ancestor, t.childPath).append(name) : child.getQualifiedName().append(name);
        }
        return DSL.name("alias_" + Internal.hash(name));
    }

    @NotNull
    public static final <T> Parameter<T> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, null, null);
    }

    @NotNull
    public static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<T, U> converter) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, converter, null);
    }

    @NotNull
    public static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Binding<T, U> binding) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, null, binding);
    }

    @NotNull
    public static final <T, X, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<X, U> converter, Binding<T, X> binding) {
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        return new ParameterImpl<T>(ParamMode.IN, DSL.name(name), actualType, isDefaulted, isUnnamed);
    }

    private Internal() {
    }

    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final Index createIndex(String name, Table<?> table, OrderField<?>[] sortFields, boolean unique) {
        return Internal.createIndex(DSL.name(name), table, sortFields, unique);
    }

    @SafeVarargs
    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, String name, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, name, fields, true);
    }

    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, String name, TableField<R, ?>[] fields, boolean enforced) {
        return Internal.createUniqueKey(table, DSL.name(name), fields, enforced);
    }

    @SafeVarargs
    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, String name, TableField<R, ?> ... fields) {
        return Internal.createForeignKey(key, table, name, fields, true);
    }

    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, String name, TableField<R, ?>[] fields, boolean enforced) {
        return Internal.createForeignKey(table, DSL.name(name), fields, key, key.getFieldsArray(), enforced);
    }

    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record, ER extends EmbeddableRecord<ER>> TableField<R, ?>[] fields(TableField<R, ER> embeddableField) {
        return ((EmbeddableTableField)embeddableField).fields;
    }

    @Deprecated(since="3.16", forRemoval=true)
    @NotNull
    public static final <R extends Record, ER extends EmbeddableRecord<ER>> Row fieldsRow(TableField<R, ER> embeddableField) {
        return embeddableField.getDataType().getRow();
    }

    @Support
    static final <T> Field<T> ineg(Field<T> field) {
        return new Neg<T>(field, true);
    }

    @Support
    static final <T> Field<T> iadd(Field<T> lhs, Field<?> rhs) {
        return new IAdd<T>(lhs, Tools.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> isub(Field<T> lhs, Field<?> rhs) {
        return new ISub<T>(lhs, Tools.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> imul(Field<T> lhs, Field<?> rhs) {
        return new IMul<T>(lhs, Tools.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> idiv(Field<T> lhs, Field<?> rhs) {
        return new IDiv<T>(lhs, Tools.nullSafe(rhs, lhs.getDataType()));
    }

    public static final <T> Subscriber<T> subscriber(final Consumer<? super Subscription> subscription, final Consumer<? super T> onNext, final Consumer<? super Throwable> onError, final Runnable onComplete) {
        return new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                subscription.accept(s);
            }

            public void onNext(T t) {
                onNext.accept(t);
            }

            public void onError(Throwable t) {
                onError.accept(t);
            }

            public void onComplete() {
                onComplete.run();
            }
        };
    }

    public static final <T> Class<T[]> arrayType(Class<T> type) {
        return type.arrayType();
    }

    public static final <R extends Record> Result<R> result(R record) {
        return new ResultImpl(Tools.configuration(record), (AbstractRow)((AbstractRecord)record).fields);
    }

    public static final boolean commercial() {
        return Tools.CONFIG.get().commercial();
    }

    public static final boolean commercial(Supplier<String> logMessage) {
        return Tools.CONFIG.get().commercial(logMessage);
    }

    public static final void requireCommercial(Supplier<String> logMessage) throws DataAccessException {
        Tools.CONFIG.get().requireCommercial(logMessage);
    }

    public static final int hash(QueryPart part) {
        return Internal.hash0(Tools.CTX.get().render(part));
    }

    static final int hash0(Object object) {
        if (object == null) {
            return 0;
        }
        return 0x7FFFFFF & object.hashCode();
    }

    public static final ConverterContext converterContext() {
        return CONVERTER_SCOPE.get();
    }

    public static final int javaVersion() {
        return JAVA_VERSION.get();
    }

    @Deprecated(forRemoval=true)
    public static final Object[] convert(Object[] values, Field<?>[] fields) {
        return Convert.convert(values, fields);
    }

    @Deprecated(forRemoval=true)
    public static final Object[] convert(Object[] values, Class<?>[] types) {
        return Convert.convert(values, types);
    }

    @Deprecated(forRemoval=true)
    public static final <U> U[] convertArray(Object[] from, Converter<?, ? extends U> converter) throws DataTypeException {
        return Convert.convertArray(from, converter);
    }

    @Deprecated(forRemoval=true)
    public static final Object[] convertArray(Object[] from, Class<?> toClass) throws DataTypeException {
        return Convert.convertArray(from, toClass);
    }

    @Deprecated(forRemoval=true)
    public static final <U> U[] convertCollection(Collection from, Class<? extends U[]> to) {
        return Convert.convertCollection(from, to);
    }

    @Deprecated(forRemoval=true)
    public static final <U> U convert(Object from, Converter<?, ? extends U> converter) throws DataTypeException {
        return Convert.convert(from, converter);
    }

    @Deprecated(forRemoval=true)
    public static final <T> T convert(Object from, Class<? extends T> toClass) throws DataTypeException {
        return Convert.convert(from, toClass);
    }

    @Deprecated(forRemoval=true)
    public static final <T> List<T> convert(Collection<?> collection, Class<? extends T> type) throws DataTypeException {
        return Convert.convert(collection, type);
    }

    @Deprecated(forRemoval=true)
    public static final <U> List<U> convert(Collection<?> collection, Converter<?, ? extends U> converter) throws DataTypeException {
        return Convert.convert(collection, converter);
    }
}

