/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.List;
import java.util.Set;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.ArrayOfValues;
import org.jooq.impl.ArrayTable;
import org.jooq.impl.AutoAlias;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.FunctionTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;

final class WithOrdinalityTable<R extends Record>
extends AbstractTable<R>
implements AutoAlias<Table<R>>,
QOM.WithOrdinalityTable<R> {
    static final Set<SQLDialect> NO_SUPPORT_STANDARD = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> NO_SUPPORT_TVF = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB);
    static final Set<SQLDialect> NO_SUPPORT_TABLE_EXPRESSIONS = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    final AbstractTable<?> delegate;

    WithOrdinalityTable(AbstractTable<?> delegate) {
        super(delegate.getOptions(), delegate.getQualifiedName(), delegate.getSchema());
        this.delegate = delegate;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final List<ForeignKey<R, ?>> getReferences() {
        return this.delegate.getReferences();
    }

    @Override
    final FieldsImpl<R> fields0() {
        FieldsImpl r = new FieldsImpl(this.delegate.fields0().fields);
        for (int i = 0; i < r.fields.length; ++i) {
            r.fields[i] = DSL.field(this.delegate.getUnqualifiedName().append(r.fields[i].getUnqualifiedName()), r.fields[i].getDataType());
        }
        r.add(DSL.field(Names.N_ORDINAL, SQLDataType.BIGINT));
        return r;
    }

    @Override
    public final Table<R> autoAlias(Context<?> ctx, Table<R> t) {
        if (t != this && t instanceof AutoAlias) {
            AutoAlias a = (AutoAlias)((Object)t);
            return a.autoAlias(ctx, t);
        }
        if (t instanceof QOM.Aliasable) {
            Object[] fields;
            QOM.Aliasable a = (QOM.Aliasable)((Object)t);
            Name alias = a.$alias();
            if (alias == null) {
                alias = ((Table)a.$aliased()).getUnqualifiedName();
            }
            if (Tools.isEmpty(fields = t.fields())) {
                return t.as(alias);
            }
            return t.as((Table<?>)DSL.table(alias), (Field<?>[])fields);
        }
        return null;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.delegate instanceof ArrayTable || this.delegate instanceof ArrayOfValues) {
            if (NO_SUPPORT_STANDARD.contains((Object)ctx.dialect())) {
                this.acceptEmulation(ctx);
            } else {
                this.acceptStandard(ctx);
            }
        } else if (this.delegate instanceof FunctionTable && NO_SUPPORT_TVF.contains((Object)ctx.dialect())) {
            if (NO_SUPPORT_TVF.contains((Object)ctx.dialect())) {
                this.acceptEmulation(ctx);
            } else {
                this.acceptStandard(ctx);
            }
        } else if (this.delegate instanceof TableImpl && ((TableImpl)this.delegate).parameters != null) {
            if (NO_SUPPORT_TVF.contains((Object)ctx.dialect())) {
                this.acceptEmulation(ctx);
            } else {
                this.acceptStandard(ctx);
            }
        } else if (NO_SUPPORT_TABLE_EXPRESSIONS.contains((Object)ctx.dialect())) {
            this.acceptEmulation(ctx);
        } else {
            this.acceptStandard(ctx);
        }
    }

    private final void acceptStandard(Context<?> ctx) {
        ctx.visit(this.delegate).sql(' ').visit(Keywords.K_WITH).sql(' ').visit(Keywords.K_ORDINALITY);
    }

    private final void acceptEmulation(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        SelectJoinStep s = DSL.select(this.delegate.fields()).select(DSL.rowNumber().over().as(Names.N_ORDINAL)).from((TableLike<?>)this.delegate);
        switch (ctx.family()) {
            default: 
        }
        Tools.visitSubquery(ctx, s, 1, true);
    }

    @Override
    public final Table<?> $table() {
        return this.delegate;
    }

    @Override
    public final WithOrdinalityTable<?> $table(Table<?> newTable) {
        return new WithOrdinalityTable<R>((AbstractTable)newTable);
    }

    @Override
    public final Table<R> $aliased() {
        return new WithOrdinalityTable<R>((AbstractTable)this.delegate.$aliased());
    }

    @Override
    public final Name $alias() {
        return this.delegate.$alias();
    }

    static {
        NO_SUPPORT_TVF.addAll(NO_SUPPORT_STANDARD);
        NO_SUPPORT_TABLE_EXPRESSIONS.addAll(NO_SUPPORT_TVF);
    }
}

