/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.util.List;
import java.util.Map;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public record TemplateResponseData(@Nullable Document mapping, @Nullable Settings settings, Map<String, AliasData> aliases, List<String> composedOf) {
    public TemplateResponseData {
        Assert.notNull(aliases, (String)"aliases must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private Document mapping;
        @Nullable
        private Settings settings;
        @Nullable
        private Map<String, AliasData> aliases;
        @Nullable
        private List<String> composedOf;

        public Builder withMapping(@Nullable Document mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withSettings(@Nullable Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder withAliases(@Nullable Map<String, AliasData> aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder withComposedOf(@Nullable List<String> composedOf) {
            this.composedOf = composedOf;
            return this;
        }

        public TemplateResponseData build() {
            return new TemplateResponseData(this.mapping, this.settings, this.aliases != null ? this.aliases : Map.of(), this.composedOf != null ? this.composedOf : List.of());
        }
    }
}

