#
# Copyright (c) 2018-2023 Red Hat, Inc.
# This program and the accompanying materials are made
# available under the terms of the Eclipse Public License 2.0
# which is available at https://www.eclipse.org/legal/epl-2.0/
#
# SPDX-License-Identifier: EPL-2.0
#
# Contributors:
#   Red Hat, Inc. - initial API and implementation
#

# https://registry.access.redhat.com/ubi8/python-38
FROM registry.access.redhat.com/ubi8/python-38:1-131 as builder
#FROM registry-proxy.engineering.redhat.com/ubi8/python-38:1 as builder
USER 0

# Keep old BOOTSTRAP variable as the rhel.install script still checks them
ARG BOOTSTRAP=true
ENV BOOTSTRAP=${BOOTSTRAP}

# Install deps
COPY ./build/dockerfiles/content_sets_rhel8.repo /etc/yum.repos.d/
COPY ./build/dockerfiles/rhel.install.sh /tmp
RUN /tmp/rhel.install.sh && rm -f /tmp/rhel.install.sh
RUN npm install --location=global yarn

# Copy files needed for the plugin registry build/artifact creation
COPY ./build.sh ./*.yml ./*.yaml ./*.js ./*.json /build/
COPY ./build /build/build/

# Run plugin registry build to generate artifacts
WORKDIR /build/
RUN SKIP_FORMAT=true SKIP_LINT=true SKIP_TEST=true ./build.sh --offline --skip-oci-image
