---
title: "Traefik Migration Documentation"
description: "Learn the steps needed to migrate to new Traefik Proxy v3 versions. Read the technical documentation."
---

# Migration: Steps needed between the versions

## v3.0 to v3.1

### Kubernetes Provider RBACs

Starting with v3.1, the Kubernetes Providers now use the [EndpointSlices API](https://kubernetes.io/docs/concepts/services-networking/endpoint-slices/) (Kubernetes >=v1.21) to discover service endpoint addresses.
It also brings NodePort load-balancing which requires Nodes resources lookup.

Therefore, in the corresponding RBACs (see [KubernetesIngress](../routing/providers/kubernetes-ingress.md#configuration-example), [KubernetesCRD](../reference/dynamic-configuration/kubernetes-crd.md#rbac), and [KubernetesGateway](../reference/dynamic-configuration/kubernetes-gateway-rbac.yml) provider RBACs):

- the `endpoints` right has to be removed and the following `endpointslices` right has to be added:

```yaml
  ... 
  - apiGroups:
      - discovery.k8s.io
    resources:
      - endpointslices
    verbs:
      - list
      - watch
  ...
```

- the `nodes` right has to be added:

```yaml
  ...
  - apiGroups:
      - ""
    resources:
      - nodes
    verbs:
      - get
      - list
      - watch
  ...
```

#### Gateway API: KubernetesGateway Provider

In v3.1, the KubernetesGateway Provider is no longer an experimental feature.
It can be enabled without the associated `experimental.kubernetesgateway` option, which is now deprecated.

??? example "An example of the experimental `kubernetesgateway` option"

    ```yaml tab="File (YAML)"
    experimental:
      kubernetesgateway: true
    ```

    ```toml tab="File (TOML)"
    [experimental]
        kubernetesgateway=true
    ```

    ```bash tab="CLI"
    --experimental.kubernetesgateway=true
    ```

##### Remediation

The `kubernetesgateway` option should be removed from the experimental section of the static configuration.
To configure `kubernetesgateway`, please check out the [KubernetesGateway Provider documentation](../providers/kubernetes-gateway.md).

## v3.1.0 to v3.1.1

### IngressClass Lookup

The Kubernetes Ingress provider option `disableIngressClassLookup` has been deprecated in v3.1.1, and will be removed in the next major version.
Please use the `disableClusterScopeResources` option instead to avoid cluster scope resources discovery (IngressClass, Nodes).

## v3.1 to v3.2

### Kubernetes CRD Provider

Starting with v3.2, the CRDs has been updated on [TraefikService](../../routing/services#mirroring-service) (PR [#11032](https://github.com/traefik/traefik/pull/11032)), on [RateLimit](../../middlewares/http/ratelimit) & [InFlightReq](../../middlewares/http/inflightreq) middlewares (PR [#9747](https://github.com/traefik/traefik/pull/9747)) and on [Compress](../../middlewares/http/compress) middleware (PR [#10943](https://github.com/traefik/traefik/pull/10943)).

This update adds only new optional fields.
CRDs can be updated with this command:

```shell
kubectl apply -f https://raw.githubusercontent.com/traefik/traefik/v3.3/docs/content/reference/dynamic-configuration/kubernetes-crd-definition-v1.yml
```

### Kubernetes Gateway Provider Standard Channel

Starting with v3.2, the Kubernetes Gateway Provider now supports [GRPCRoute](https://gateway-api.sigs.k8s.io/api-types/grpcroute/).

Therefore, in the corresponding RBACs (see [KubernetesGateway](../reference/dynamic-configuration/kubernetes-gateway-rbac.yml) provider RBACs),
the `grcroutes` and `grpcroutes/status` rights have to be added.

```yaml
  ...
  - apiGroups:
      - gateway.networking.k8s.io
    resources:
      - grpcroutes
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - gateway.networking.k8s.io
    resources:
      - grpcroutes/status
    verbs:
      - update
  ...
```

### Kubernetes Gateway Provider Experimental Channel

!!! warning "Breaking changes"

    Because of a breaking change introduced in Kubernetes Gateway [v1.2.0-rc1](https://github.com/kubernetes-sigs/gateway-api/releases/tag/v1.2.0-rc1),
    Traefik v3.3 only supports Kubernetes Gateway v1.2.x when experimental channel features are enabled.

Starting with v3.2, the Kubernetes Gateway Provider now supports [BackendTLSPolicy](https://gateway-api.sigs.k8s.io/api-types/backendtlspolicy/).

Therefore, in the corresponding RBACs (see [KubernetesGateway](../reference/dynamic-configuration/kubernetes-gateway-rbac.yml) provider RBACs),
the `backendtlspolicies` and `backendtlspolicies/status` rights have to be added.

```yaml
  ...
  - apiGroups:
      - ""
    resources:
      - configmaps
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - gateway.networking.k8s.io
    resources:
      - backendtlspolicies
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - gateway.networking.k8s.io
    resources:
      - backendtlspolicies/status
    verbs:
      - update
  ...
```

## v3.2.1

### X-Forwarded-Prefix

In `v3.2.1`, the `X-Forwarded-Prefix` header is now handled like the other `X-Forwarded-*` headers: Traefik removes it when it's sent from an untrusted source.
Please refer to the Forwarded headers [documentation](../routing/entrypoints.md#forwarded-headers) for more details.

## v3.2.2

### Swarm Provider

In `v3.2.2`, the `traefik.docker.network` and `traefik.docker.lbswarm` labels have been deprecated,
please use the `traefik.swarm.network` and `traefik.swarm.lbswarm` labels instead.

## v3.2 to v3.3

### ACME DNS Certificate Resolver

In `v3.3`, the `acme.dnsChallenge.delaybeforecheck` and `acme.dnsChallenge.disablepropagationcheck` options of the ACME certificate resolver are deprecated, 
please use respectively `acme.dnsChallenge.propagation.delayBeforeChecks` and `acme.dnsChallenge.propagation.disableChecks` options instead.

### Tracing Global Attributes

In `v3.3`, the `tracing.globalAttributes` option has been deprecated, please use the `tracing.resourceAttributes` option instead.
The `tracing.globalAttributes` option is misleading as its name does not reflect the operation of adding resource attributes to be sent to the collector,
and will be removed in the next major version.

## v3.3.4

### OpenTelemetry Request Duration metric

In `v3.3.4`, the OpenTelemetry Request Duration metric (named `traefik_(entrypoint|router|service)_request_duration_seconds`) unit has been changed from milliseconds to seconds.
To be consistent with the naming and other metrics providers, the metric now reports the duration in seconds.

## v3.3.5

### Compress Middleware

In `v3.3.5`, the compress middleware `encodings` option default value is now `gzip, br, zstd`. 
This change helps the algorithm selection to favor the `gzip` algorithm over the other algorithms.

It impacts requests that do not specify their preferred algorithm,
or has no order preference, in the `Accept-Encoding` header.
