/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.base.LoggingConnector;
import com.metamatrix.connector.xml.cache.DocumentCache;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.cache.RequestRecord;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCachingConnector
extends LoggingConnector
implements CachingConnector {
    private IDocumentCache m_documentCache;
    private IDocumentCache m_statementCache;
    private Map requestInfo;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        try {
            super.initialize(env);
            this.m_documentCache = new DocumentCache(this.m_state.getMaxMemoryCacheSizeByte(), this.m_state.getMaxFileCacheSizeByte(), this.m_state.getCacheLocation(), this.m_state.getCacheTimeoutMillis(), this.getLogger(), env.getConnectorName(), true);
            this.m_statementCache = new DocumentCache(0x3FFFFFFF, 0, this.m_state.getCacheLocation(), 0x3FFFFFFF, this.getLogger(), env.getConnectorName() + "_STMT", false);
            this.requestInfo = new HashMap();
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public IDocumentCache getCache() {
        return this.m_documentCache;
    }

    public IDocumentCache getStatementCache() {
        return this.m_statementCache;
    }

    public void stop() {
        if (this.m_documentCache != null) {
            this.getLogger().logTrace("Shutting down cache cleaner");
            this.m_documentCache.shutdownCleaner();
        }
    }

    public void createCacheObjectRecord(String requestID, String partID, String sourceRequestID, String cacheKey) throws ConnectorException {
        RequestRecord request = (RequestRecord)this.requestInfo.get(requestID);
        if (null == request) {
            request = new RequestRecord(requestID, this);
            this.requestInfo.put(requestID, request);
            this.getLogger().logTrace("Creating RequestRecord for Request Identifier " + requestID);
            request.addRequestPart(partID, sourceRequestID, cacheKey, this.getLogger());
        } else {
            request.addRequestPart(partID, sourceRequestID, cacheKey, this.getLogger());
        }
    }

    public void deleteCacheItems(String requestID, String partID) {
        RequestRecord request = (RequestRecord)this.requestInfo.get(requestID);
        if (null != request) {
            request.deleteRequestPart(partID, this.getLogger());
            if (request.isEmpty()) {
                this.requestInfo.remove(requestID);
                this.getLogger().logTrace("Removed RequestRecord for Request Identifier " + requestID);
            }
        }
    }
}

