/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.file;

import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.NamedDocumentExecutor;
import com.metamatrix.connector.xml.SAXFilterProvider;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.LoggingInputStreamFilter;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.base.XMLExtractor;
import com.metamatrix.connector.xml.cache.DocumentCache;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.file.FileConnectorState;
import com.metamatrix.connector.xml.file.Messages;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.jdom.Document;

public class FileExecutor
implements DocumentProducer,
NamedDocumentExecutor {
    public static final String PARM_FILE_NAME_TABLE_PROPERTY_NAME = "FileName";
    private String[] m_docs;
    private String m_directory;
    private FileConnectorState m_state;
    private XMLExecution execution;
    private XMLExtractor xmlExtractor;

    public FileExecutor(FileConnectorState state, XMLExecution execution) throws ConnectorException {
        this.m_state = state;
        this.execution = execution;
        String cacheLocation = this.m_state.getCacheLocation();
        File cacheFolder = cacheLocation == null || cacheLocation.trim().length() == 0 ? null : new File(cacheLocation);
        this.xmlExtractor = new XMLExtractor(this.m_state.getMaxInMemoryStringSize(), this.m_state.isPreprocess(), this.m_state.isLogRequestResponse(), cacheFolder, this.m_state.getLogger());
        this.validateParams();
        String tableFileName = this.getTableFileName();
        String xmlFileName = this.m_state.getFileName();
        if (tableFileName != null && tableFileName.trim().length() == 0) {
            tableFileName = null;
        }
        if (xmlFileName.trim().length() == 0) {
            xmlFileName = null;
        }
        String xmlFileDir = this.m_state.getDirectoryPath();
        this.m_directory = this.normalizePath(xmlFileDir);
        if (tableFileName == null && xmlFileName == null) {
            this.validateDirectory();
        } else {
            this.validateFile(tableFileName, xmlFileName, xmlFileDir);
        }
    }

    public int getDocumentCount() throws ConnectorException {
        return this.m_docs.length;
    }

    public String getCacheKey(int i) throws ConnectorException {
        String myXmlFileName = this.m_directory + this.m_docs[i];
        return myXmlFileName;
    }

    public InputStream getDocumentStream(int i) throws ConnectorException {
        try {
            String xmlFileName = this.m_directory + this.m_docs[i];
            File xmlFile = new File(xmlFileName);
            this.m_state.getLogger().logDetail("XML Connector Framework: retrieving document from " + xmlFileName);
            FileInputStream retval = new FileInputStream(xmlFile);
            this.m_state.getLogger().logDetail("XML Connector Framework: retrieved file " + xmlFileName);
            return retval;
        }
        catch (IOException ioe) {
            throw new ConnectorException((Throwable)ioe);
        }
    }

    public Response getXMLResponse(int invocationNumber) throws ConnectorException {
        Response result;
        IDocumentCache cache = this.execution.getCache();
        CriteriaDesc criterion = this.execution.getInfo().getResponseIDCriterion();
        ExecutionContext exeContext = this.execution.getExeContext();
        String requestID = exeContext.getRequestIdentifier();
        String partID = exeContext.getPartIdentifier();
        if (null != criterion) {
            String cacheKey = (String)criterion.getValues().get(0);
            result = new Response(cacheKey, this, cache, this.m_state.isErrorOnRecreateDoc(), exeContext.getRequestIdentifier(), exeContext.getPartIdentifier());
            this.execution.getConnection().getConnector().createCacheObjectRecord(requestID, partID, Integer.toString(invocationNumber), cacheKey);
        } else {
            int documentCount = this.getDocumentCount();
            String[] cacheKeys = new String[documentCount];
            XMLDocument[] docs = new XMLDocument[documentCount];
            for (int docNumber = 0; docNumber < documentCount; ++docNumber) {
                String cacheKey = this.getCacheKey(docNumber);
                XMLDocument doc = DocumentCache.cacheLookup(cache, cacheKey, requestID, partID);
                if (doc == null) {
                    String documentDistinguishingId = "";
                    if (documentCount > 1) {
                        documentDistinguishingId = this.getDocumentName(docNumber);
                    }
                    SAXFilterProvider provider = null;
                    provider = this.m_state.getSAXFilterProvider();
                    InputStream responseBody = this.getDocumentStream(docNumber);
                    InputStream filteredStream = this.addStreamFilters(responseBody, this.m_state.getLogger());
                    DocumentInfo info = this.xmlExtractor.createDocumentFromStream(filteredStream, documentDistinguishingId, provider);
                    Document domDoc = info.m_domDoc;
                    doc = new XMLDocument(domDoc, info.m_externalFiles);
                    cache.addToCache(cacheKey, doc, info.m_memoryCacheSize, requestID, partID);
                    this.execution.getConnection().getConnector().createCacheObjectRecord(requestID, partID, Integer.toString(docNumber), cacheKey);
                }
                docs[docNumber] = doc;
                cacheKeys[docNumber] = cacheKey;
            }
            result = new Response(docs, cacheKeys, this, cache, this.m_state.isErrorOnRecreateDoc(), exeContext.getRequestIdentifier(), exeContext.getRequestIdentifier());
        }
        return result;
    }

    public InputStream addStreamFilters(InputStream response, ConnectorLogger logger) throws ConnectorException {
        if (this.m_state.isLogRequestResponse()) {
            response = new LoggingInputStreamFilter(response, logger);
        }
        InputStream filter = null;
        try {
            Class<?> pluggableFilter = Class.forName(this.m_state.getPluggableInputStreamFilterClass());
            Constructor<?> ctor = pluggableFilter.getConstructor(InputStream.class, ConnectorLogger.class);
            filter = (InputStream)ctor.newInstance(response, logger);
        }
        catch (Exception cnf) {
            throw new ConnectorException((Throwable)cnf);
        }
        return filter;
    }

    public String getDocumentName(int i) throws ConnectorException {
        return this.m_docs[i];
    }

    public Serializable getRequestObject(int i) throws ConnectorException {
        return this.m_docs[i];
    }

    public XMLDocument recreateDocument(Serializable requestObject) throws ConnectorException {
        String request = (String)((Object)requestObject);
        XMLDocument doc = null;
        try {
            String xmlFileName = request;
            File xmlFile = new File(xmlFileName);
            this.m_state.getLogger().logDetail("XML Connector Framework: retrieving document from " + xmlFileName);
            FileInputStream retval = new FileInputStream(xmlFile);
            this.m_state.getLogger().logDetail("XML Connector Framework: retrieved file " + xmlFileName);
            SAXFilterProvider provider = null;
            try {
                provider = this.m_state.getSAXFilterProvider();
            }
            catch (Exception e) {
                throw new ConnectorException((Throwable)e);
            }
            DocumentInfo info = this.xmlExtractor.createDocumentFromStream(retval, request, provider);
            doc = new XMLDocument();
            doc.setContextRoot(info.m_domDoc);
            doc.setExternalFiles(info.m_externalFiles);
        }
        catch (IOException ioe) {
            throw new ConnectorException((Throwable)ioe);
        }
        return doc;
    }

    private String getTableFileName() {
        String retval = this.execution.getInfo().getLocation();
        if (retval == null) {
            retval = this.execution.getInfo().getOtherProperties().getProperty(PARM_FILE_NAME_TABLE_PROPERTY_NAME);
        }
        return retval;
    }

    private String normalizePath(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return new String(path + File.separator);
    }

    private void validateParams() throws ConnectorException {
        for (int i = 0; i < this.execution.getInfo().getRequestedColumns().size(); ++i) {
            OutputXPathDesc xPath = (OutputXPathDesc)this.execution.getInfo().getRequestedColumns().get(i);
            if (!xPath.isParameter()) continue;
            throw new ConnectorException(Messages.getString("FileExecutor.input.not.supported.on.files"));
        }
    }

    private void validateDirectory() throws ConnectorException {
        File dirFile = new File(this.m_directory);
        String[] files = dirFile.list();
        ArrayList<String> xmlFiles = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            boolean valid = this.validateFile(files[i], this.m_directory, true);
            if (!valid) continue;
            xmlFiles.add(files[i]);
        }
        files = new String[xmlFiles.size()];
        xmlFiles.toArray(files);
        this.m_docs = files;
        if (this.m_docs.length <= 0) {
            throw new ConnectorException(Messages.getString("FileExecutor.empty.directory"));
        }
    }

    private boolean validateFile(String fileName, String directory, boolean validateExtension) {
        boolean result = false;
        String myXmlFileName = this.normalizePath(directory) + fileName;
        File xmlFile = new File(myXmlFileName);
        if (xmlFile.isFile()) {
            if (validateExtension) {
                if (myXmlFileName.toLowerCase().endsWith(".xml")) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private void validateFile(String tableFileName, String xmlFileName, String xmlFileDir) throws ConnectorException {
        this.m_docs = new String[1];
        this.m_docs[0] = tableFileName == null ? xmlFileName : tableFileName;
        boolean valid = this.validateFile(this.m_docs[0], xmlFileDir, false);
        if (!valid) {
            throw new ConnectorException(Messages.getString("FileExecutor.not.file"));
        }
    }
}

