/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.client.IConnectionInstanceMgr;
import com.metamatrix.common.comm.platform.socket.client.ServerInstanceFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.comm.service.SocketService;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class SocketServerInstancePool
implements IConnectionInstanceMgr {
    public static final String COMMA_DELIMITER = ",";
    private Random random = new Random();
    private Map socketServerInstances = new HashMap(20);
    private Set virtualSocketIDs = new HashSet(10);
    private Map clusterDataMap = new HashMap(10);
    private ServerInstanceFactory serverInstanceFactory = null;
    private boolean defaultSSL = false;
    private static int socketsPerVM = 5;

    public SocketServerInstancePool(ServerInstanceFactory serverInstanceFactory) {
        this.serverInstanceFactory = serverInstanceFactory;
    }

    public void setSocketsPerVM(int newSocketsPerVM) {
        socketsPerVM = newSocketsPerVM;
    }

    public int getSocketsPerVM() {
        return socketsPerVM;
    }

    public synchronized void loadLogonServerInstances(Collection socketServiceList, String resourceType, String clusterName) {
        if (socketServiceList == null || socketServiceList.isEmpty()) {
            return;
        }
        boolean ssl = this.isSecureConnection(clusterName);
        ResourceType rt = this.getResourceType(clusterName, resourceType);
        if (rt == null) {
            rt = new ResourceType(resourceType);
        } else {
            rt.clearProcess();
        }
        try {
            Iterator i = socketServiceList.iterator();
            while (i.hasNext()) {
                SocketService ss = (SocketService)i.next();
                if (ss == null) continue;
                LogonHostInfo process = new LogonHostInfo(ss.getHost(), ss.getPort(), ss.getInetAddress(), clusterName, ssl);
                rt.addHost(process);
            }
        }
        catch (RemoteException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        this.getClusterData((String)clusterName).resourceMap.put(resourceType, rt);
    }

    public void setLogonProcess(HostInfo process, String resourceType) {
        ResourceType rt = this.getResourceType(process.getClusterName(), resourceType);
        if (rt != null && rt.getLogonProcessAddress() == null && process.getHostName() != null && rt != null) {
            rt.setLogonProcessAddress(process.getHostName());
        }
    }

    public String getLogonHostAddress(String clusterName, String resourceType) {
        ResourceType rt = this.getResourceType(clusterName, resourceType);
        if (rt != null) {
            return rt.getLogonProcessAddress();
        }
        return null;
    }

    public synchronized void loadServerInstances(Collection socketServiceList, String resourceType, String clusterName) {
        if (socketServiceList == null || socketServiceList.isEmpty()) {
            return;
        }
        boolean ssl = this.isSecureConnection(clusterName);
        ResourceType rt = this.getResourceType(clusterName, resourceType);
        if (rt == null) {
            rt = new ResourceType(resourceType);
        } else {
            rt.clearProcess();
        }
        try {
            Iterator i = socketServiceList.iterator();
            while (i.hasNext()) {
                SocketService ss = (SocketService)i.next();
                if (ss == null) continue;
                HostInfo process = new HostInfo(ss.getHost(), ss.getPort(), ss.getInetAddress(), clusterName, ssl);
                rt.addHost(process);
            }
        }
        catch (RemoteException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        this.getClusterData((String)clusterName).resourceMap.put(resourceType, rt);
    }

    public synchronized void addVirtualSocketID(int virtualSocketID) {
        this.virtualSocketIDs.add(new Integer(virtualSocketID));
    }

    public synchronized void removeVirtualSocketID(int virtualSocketID) {
        this.virtualSocketIDs.remove(new Integer(virtualSocketID));
    }

    public synchronized ServerInstance getServerInstance(String clusterName, String resourceType, boolean useSameConnection, boolean isConnected) throws CommunicationException {
        List processes = new ArrayList();
        ResourceType resource = this.getResourceType(clusterName, resourceType);
        if (resource != null) {
            processes = resource.getProcesses();
        }
        if (processes.isEmpty()) {
            this.revertToStartupHosts(resourceType, clusterName);
        }
        if (processes.isEmpty()) {
            throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketServerInstancePool.No_valid_host_available", new Object[]{clusterName, resourceType}));
        }
        ServerInstance instance = null;
        CommunicationException firstException = null;
        boolean triedReverting = false;
        while (!processes.isEmpty()) {
            HostInfo process;
            block8: {
                int numberOfProcesses = processes.size();
                this.getClusterData(clusterName);
                int r = this.random.nextInt(numberOfProcesses);
                process = (HostInfo)processes.get(r);
                try {
                    instance = this.findServerInstance(process, isConnected);
                    if (instance != null && instance.isOpen()) {
                        return instance;
                    }
                }
                catch (CommunicationException e) {
                    if (firstException != null) break block8;
                    firstException = e;
                }
            }
            resource.removeProcess(process);
            this.destroyServerInstances(process);
            processes.remove(process);
            if (!processes.isEmpty() || triedReverting) continue;
            triedReverting = true;
            this.revertToStartupHosts(resourceType, clusterName);
        }
        if (firstException != null) {
            throw firstException;
        }
        throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketServerInstancePool.No_valid_host_available", new Object[]{clusterName, resourceType}));
    }

    synchronized void setSecureConnection(String clusterName, boolean ssl) {
        this.getClusterData((String)clusterName).isSSL = ssl;
        if (clusterName.startsWith("DEFAULT_CLUSTER")) {
            this.defaultSSL = ssl;
        }
    }

    boolean isSecureConnection(String clusterName) {
        Boolean ssl = this.getClusterData((String)clusterName).isSSL;
        if (ssl == null) {
            return this.defaultSSL;
        }
        return ssl;
    }

    public synchronized void removeServerInstance(ServerInstance si) {
        SocketServerInstance ssi = (SocketServerInstance)si;
        HostInfo process = ssi.getHostInfo();
        if (!this.hasConnectedVirtualSockets(process)) {
            this.destroyServerInstances(process);
        }
    }

    private boolean hasConnectedVirtualSockets(HostInfo process) {
        List instances = (List)this.socketServerInstances.get(process);
        if (instances == null) {
            return false;
        }
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            SocketServerInstance instance = (SocketServerInstance)iter.next();
            if (instance.getConnectedVirtualSocketCount() <= 0) continue;
            return true;
        }
        return false;
    }

    synchronized ServerInstance findServerInstance(HostInfo process, boolean connected) throws CommunicationException {
        int maxSockets = Math.max(socketsPerVM, 1);
        while (true) {
            ArrayList<SocketServerInstance> instances;
            if ((instances = (ArrayList<SocketServerInstance>)this.socketServerInstances.get(process)) == null) {
                instances = new ArrayList<SocketServerInstance>(maxSockets);
                this.socketServerInstances.put(process, instances);
            }
            if (!connected && instances.size() < maxSockets || instances.size() == 0) {
                SocketServerInstance instance = (SocketServerInstance)this.createServerInstance(process);
                instances.add(instance);
                return instance;
            }
            maxSockets = instances.size();
            SocketServerInstance result = (SocketServerInstance)instances.get(this.random.nextInt(maxSockets));
            if (result.isOpen()) {
                return result;
            }
            result.shutdown();
            this.removeServerInstance(result);
        }
    }

    protected synchronized int getVirtualSocketCount() {
        return this.virtualSocketIDs.size();
    }

    public synchronized boolean containsServerInstance(ServerInstance serverInstance) {
        Iterator iter = this.socketServerInstances.values().iterator();
        while (iter.hasNext()) {
            List instances = (List)iter.next();
            if (!instances.contains(serverInstance)) continue;
            return true;
        }
        return false;
    }

    private ServerInstance createServerInstance(HostInfo process) throws CommunicationException {
        return this.serverInstanceFactory.createServerInstance(process);
    }

    private synchronized void destroyServerInstances(HostInfo process) {
        List instances = (List)this.socketServerInstances.get(process);
        if (instances == null) {
            return;
        }
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            SocketServerInstance instance = (SocketServerInstance)iter.next();
            if (instance == null) continue;
            instance.shutdown();
        }
        this.socketServerInstances.remove(process);
    }

    synchronized void updateClusterName(String oldClusterName, String newClusterName) {
        Iterator<Object> iter;
        if (oldClusterName.equals(newClusterName)) {
            return;
        }
        ClusterData newClusterData = (ClusterData)this.clusterDataMap.remove(oldClusterName);
        if (newClusterData != null) {
            this.clusterDataMap.put(newClusterName, newClusterData);
            iter = newClusterData.resourceMap.values().iterator();
            while (iter.hasNext()) {
                ResourceType resourceType = (ResourceType)iter.next();
                Iterator iter2 = resourceType.processes.iterator();
                while (iter2.hasNext()) {
                    HostInfo hostInfo = (HostInfo)iter2.next();
                    if (!oldClusterName.equals(hostInfo.getClusterName())) continue;
                    hostInfo.setClusterName(newClusterName);
                }
            }
        }
        iter = this.socketServerInstances.keySet().iterator();
        while (iter.hasNext()) {
            HostInfo hostInfo = (HostInfo)iter.next();
            if (!oldClusterName.equals(hostInfo.getClusterName())) continue;
            hostInfo.setClusterName(newClusterName);
        }
    }

    synchronized void removeCluster(String clusterName) {
        this.clusterDataMap.remove(clusterName);
        HashSet keysCopy = new HashSet(this.socketServerInstances.keySet());
        Iterator iter = keysCopy.iterator();
        while (iter.hasNext()) {
            HostInfo process = (HostInfo)iter.next();
            if (!clusterName.equals(process.getClusterName())) continue;
            List instances = (List)this.socketServerInstances.get(process);
            Iterator iter2 = instances.iterator();
            while (iter2.hasNext()) {
                ServerInstance instance = (ServerInstance)iter2.next();
                this.removeServerInstance(instance);
            }
        }
    }

    List getAvailableProcesses(String resourceType, String clusterName) {
        ResourceType rt;
        Map rts = this.getClusterData((String)clusterName).resourceMap;
        if (rts != null && (rt = (ResourceType)rts.get(resourceType)) != null) {
            return rt.getProcesses();
        }
        return Collections.EMPTY_LIST;
    }

    ResourceType getResourceType(String clusterName, String resourceType) {
        return (ResourceType)this.getClusterData((String)clusterName).resourceMap.get(resourceType);
    }

    public synchronized ServerInstance[] getServerInstances(String clusterName, String resourceType) {
        List processes = this.getAvailableProcesses(resourceType, clusterName);
        ArrayList l = new ArrayList(processes.size());
        Iterator it = processes.iterator();
        while (it.hasNext()) {
            HostInfo process = (HostInfo)it.next();
            if (!this.socketServerInstances.containsKey(process)) continue;
            l.addAll((List)this.socketServerInstances.get(process));
        }
        return l.toArray(new ServerInstance[l.size()]);
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SSIPool: " + this.hashCode() + "\n");
        Iterator processes = this.socketServerInstances.keySet().iterator();
        while (processes.hasNext()) {
            HostInfo process = (HostInfo)processes.next();
            List instances = (List)this.socketServerInstances.get(process);
            buffer.append(" SSI " + process + ": " + instances + "\n");
        }
        Iterator clusters = this.clusterDataMap.keySet().iterator();
        while (clusters.hasNext()) {
            String cluster = (String)clusters.next();
            ClusterData clusterData = (ClusterData)this.clusterDataMap.get(cluster);
            Iterator resources = clusterData.resourceMap.keySet().iterator();
            while (resources.hasNext()) {
                String resource = (String)resources.next();
                ResourceType rt = (ResourceType)clusterData.resourceMap.get(resource);
                buffer.append(" RT " + cluster + ": " + resource + ": " + rt.getProcesses() + "\n");
            }
        }
        return buffer.toString();
    }

    private synchronized ClusterData getClusterData(String clusterName) {
        ClusterData clusterData = (ClusterData)this.clusterDataMap.get(clusterName);
        if (clusterData == null) {
            clusterData = new ClusterData();
            this.clusterDataMap.put(clusterName, clusterData);
        }
        return clusterData;
    }

    public synchronized void setStartupHosts(String clusterName, Collection startupHosts) {
        Collection hosts = this.getClusterData((String)clusterName).startupHosts;
        hosts.clear();
        hosts.addAll(startupHosts);
    }

    private synchronized void revertToStartupHosts(String resourceType, String clusterName) {
        this.loadServerInstances(this.getClusterData((String)clusterName).startupHosts, resourceType, clusterName);
    }

    private class ClusterData {
        Collection startupHosts = new ArrayList();
        Map resourceMap = new HashMap();
        Boolean isSSL = null;

        private ClusterData() {
        }
    }

    class LogonHostInfo
    extends HostInfo {
        public LogonHostInfo(String host, String port) {
            super(host, port);
        }

        public LogonHostInfo(String host, int port) {
            super(host, port);
        }

        public LogonHostInfo(String host, int port, InetAddress inetAddress, String cluster, boolean ssl) {
            super(host, port, inetAddress, cluster, ssl);
        }
    }

    class ResourceType {
        private String rt;
        private List processes = Collections.synchronizedList(new ArrayList());
        private String logonProcessAddress = null;

        public ResourceType(String resourceType) {
            this.rt = resourceType;
        }

        public String getResourceType() {
            return this.rt;
        }

        public List getProcesses() {
            return this.processes;
        }

        public void removeProcess(HostInfo process) {
            this.processes.remove(process);
        }

        public void clearProcess() {
            this.processes.clear();
        }

        public void addHost(HostInfo process) {
            this.processes.add(process);
        }

        public void setLogonProcessAddress(String address) {
            this.logonProcessAddress = address;
        }

        public String getLogonProcessAddress() {
            return this.logonProcessAddress;
        }
    }
}

