/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.core.util.MetaMatrixProductVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MetaMatrixProductNames
extends MetaMatrixProductVersion {
    private static Map productsToSubsystems;
    private static Map subsystemsToAPIClassname;

    public static Collection getProductNames() {
        if (productsToSubsystems == null) {
            MetaMatrixProductNames.initializeMap();
        }
        return productsToSubsystems.keySet();
    }

    public static Collection getProductSubsystemNames(String productName) {
        if (productsToSubsystems == null) {
            MetaMatrixProductNames.initializeMap();
        }
        return (Collection)productsToSubsystems.get(productName);
    }

    public static String getAPIClassnameForSubsystemName(String subsystemName) {
        if (subsystemsToAPIClassname == null) {
            MetaMatrixProductNames.initializeClassnameMap();
        }
        return (String)subsystemsToAPIClassname.get(subsystemName);
    }

    private MetaMatrixProductNames() {
    }

    private static void initializeMap() {
        productsToSubsystems = new HashMap();
        int subsystemCount = 6;
        ArrayList<String> aList = new ArrayList<String>(subsystemCount);
        aList.add("Configuration");
        aList.add("Runtime State");
        aList.add("Membership");
        aList.add("Session");
        aList.add("Authorization");
        aList.add("Extension Source");
        productsToSubsystems.put("Platform", aList);
        subsystemCount = 4;
        aList = new ArrayList(subsystemCount);
        aList.add("Connector");
        aList.add("Query");
        aList.add("Runtime MetaData");
        aList.add("Transaction");
        productsToSubsystems.put("Integration Server", aList);
        subsystemCount = 1;
        aList = new ArrayList(subsystemCount);
        aList.add("MetaData Directory");
        productsToSubsystems.put("Repository", aList);
        productsToSubsystems.put("Connectors", Collections.EMPTY_LIST);
    }

    private static void initializeClassnameMap() {
        subsystemsToAPIClassname = new HashMap();
        subsystemsToAPIClassname.put("Configuration", "com.metamatrix.platform.admin.apiimpl.ConfigurationAdminAPIFacade");
        subsystemsToAPIClassname.put("Runtime State", "com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIFacade");
        subsystemsToAPIClassname.put("Membership", "com.metamatrix.platform.admin.apiimpl.MembershipAdminAPIFacade");
        subsystemsToAPIClassname.put("Session", "com.metamatrix.platform.admin.apiimpl.SessionAdminAPIFacade");
        subsystemsToAPIClassname.put("Authorization", "com.metamatrix.platform.admin.apiimpl.AuthorizationAdminAPIFacade");
        subsystemsToAPIClassname.put("Extension Source", "com.metamatrix.platform.admin.apiimpl.ExtensionSourceAdminAPIFacade");
        subsystemsToAPIClassname.put("Query", "com.metamatrix.server.admin.apiimpl.QueryAdminAPIFacade");
        subsystemsToAPIClassname.put("Transaction", "com.metamatrix.server.admin.apiimpl.TransactionAdminAPIFacade");
        subsystemsToAPIClassname.put("Connector", "com.metamatrix.server.admin.apiimpl.ConnectorManagementAdminAPIFacade");
        subsystemsToAPIClassname.put("Runtime MetaData", "com.metamatrix.server.admin.apiimpl.RuntimeMetadataAdminAPIFacade");
        subsystemsToAPIClassname.put("MetaData Directory", "com.metamatrix.metadata.server.admin.apiimpl.MetaDataDirectoryAdminAPIFacade");
    }

    public static class IntegrationAPI {
        public static final String JDBC = "Integration API/JDBC";
        public static final String ODBC = "Integration API/ODBC";
    }

    public static class Views {
        public static final String RELATIONAL_VIEWS = "Views/Relational";
        public static final String XML_VIEWS = "Views/XML";
    }

    public static class DQP_Product {
        public static final String PRODUCT_NAME = "Query Engine";
        public static final String TRANSACTIONS = "Query/Transactions";
        public static final String UPDATES = "Query/Updates";
        public static final String CONNECTOR_JDBC_ = "Connector/JDBC";
        public static final String CONNECTOR_TEXT_ = "Connector/Text";
        public static final String CONNECTOR_LIBRADOS_ = "Connector/Librados";
    }

    public static class MetaBaseModelerProduct {
        public static final String PRODUCT_NAME = "Modeler";
    }

    public static class ConnectorProduct {
        public static final String PRODUCT_NAME = "Connectors";
        public static final String JDBC = "Connector/JDBC";
        public static final String TEXT = "Connector/Text";
        public static final String LIBRADOS = "Connector/Librados";
        public static final String CUSTOM = "Connector/Custom";
        public static final String XML = "Connector/XML";
        public static final String DATASOURCES = "Sources";
    }

    public static class MetaDataServer {
        public static final String PRODUCT_NAME = "Repository";

        public static class SubSystemAPIClassnames {
            public static final String METADATA_DIRECTORY = "com.metamatrix.metadata.server.admin.apiimpl.MetaDataDirectoryAdminAPIFacade";
        }

        public static class SubSystemNames {
            public static final String METADATA_DIRECTORY = "MetaData Directory";
        }
    }

    public static class MetaMatrixServer {
        public static final String PRODUCT_NAME = "Integration Server";

        public static class SubSystemAPIClassnames {
            public static final String QUERY = "com.metamatrix.server.admin.apiimpl.QueryAdminAPIFacade";
            public static final String TRANSACTION = "com.metamatrix.server.admin.apiimpl.TransactionAdminAPIFacade";
            public static final String CONNECTOR = "com.metamatrix.server.admin.apiimpl.ConnectorManagementAdminAPIFacade";
            public static final String RUNTIME_METADATA = "com.metamatrix.server.admin.apiimpl.RuntimeMetadataAdminAPIFacade";
        }

        public static class SubSystemNames {
            public static final String QUERY = "Query";
            public static final String TRANSACTION = "Transaction";
            public static final String CONNECTOR = "Connector";
            public static final String RUNTIME_METADATA = "Runtime MetaData";
        }
    }

    public static class Platform {
        public static final String PRODUCT_NAME = "Platform";

        public static class SubSystemAPIClassnames {
            public static final String CONFIGURATION = "com.metamatrix.platform.admin.apiimpl.ConfigurationAdminAPIFacade";
            public static final String RUNTIME_STATE = "com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIFacade";
            public static final String MEMBERSHIP = "com.metamatrix.platform.admin.apiimpl.MembershipAdminAPIFacade";
            public static final String SESSION = "com.metamatrix.platform.admin.apiimpl.SessionAdminAPIFacade";
            public static final String AUTHORIZATION = "com.metamatrix.platform.admin.apiimpl.AuthorizationAdminAPIFacade";
            public static final String EXTENSION_SOURCE = "com.metamatrix.platform.admin.apiimpl.ExtensionSourceAdminAPIFacade";
        }

        public static class SubSystemNames {
            public static final String CONFIGURATION = "Configuration";
            public static final String RUNTIME_STATE = "Runtime State";
            public static final String MEMBERSHIP = "Membership";
            public static final String SESSION = "Session";
            public static final String AUTHORIZATION = "Authorization";
            public static final String EXTENSION_SOURCE = "Extension Source";
        }
    }
}

