/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.retroruntime.net.sf.retrotranslator.runtime.java.lang._String;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

public class WSDLServletUtil {
    public static final String SERVER_URL_KEY = "ServerURL";
    public static final String SECURE_PROTOCOL = "Secure";
    public static final String VDB_NAME_KEY = "VDBName";
    public static final String VDB_VERSION_KEY = "VDBVersion";
    public static final String ADD_PROPS = "AdditionalProperties";
    public static final String TXN_AUTO_WRAP = "txnAutoWrap";
    public static final String ADD_EXEC_PROPS = "AddExecProperties";
    public static final String MM_WEBSERVICE_QUERY_TIMEOUT = "com.metamatrix.webservice.querytimeout";
    public static final String DISCOVERED_WSDL = "discovered_wsdl";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String MMSERVER_HOST_PORT_KEY = "MMServerHostAndPort";
    public static final String TARGET_HOST_KEY = "TargetHost";
    public static final String TARGET_PORT_KEY = "TargetPort";
    public static final String SERVLET_PATH = "/servlet/ArtifactDocumentService";
    public static final String SQLQUERYWEBSERVICE_WSDL_PATH = "/services/SqlQueryWebService?wsdl";
    public static final String GENERATED_WSDL_NAME = "MetaMatrixDataServices";
    public static final String GENERATED_WSDL_FILENAME = "MetaMatrixDataServices.wsdl";
    public static final String COLON = ":";
    public static final String SLASH = "/";
    public static final String DOUBLE_SLASH = "//";
    public static final String AMP = "&";
    public static final String QUESTION_MARK = "?";
    public static final String EQUALS = "=";
    public static final String COMMA = ",";
    private static final String SQLQUERYWEBSERVICE_URL_FORMAT = "{0}://{1}:{2}/{3}";
    private static final String DEFAULT_HTTPS_PORT = "8443";
    private static final String DEFAULT_HTTP_PORT = "8080";
    private static final String HTTPS_PORT_PROPERTY_KEY = "com.metamatrix.webservice.dataservice.httpsport";
    private static final String HTTP_PORT_PROPERTY_KEY = "com.metamatrix.webservice.dataservice.httpport";

    public static String formatURL(String scheme, String host, String port, String appContext, List serverURLs, String vdbName, String vdbVersion, String txnAutoWrap) {
        StringBuffer result = new StringBuffer();
        try {
            boolean hasPort = true;
            boolean hasVDBVersion = true;
            if (port == null || port.length() == 0) {
                hasPort = false;
            }
            if (vdbVersion == null || vdbVersion.trim().length() == 0) {
                hasVDBVersion = false;
            }
            result.append(scheme).append(COLON).append(DOUBLE_SLASH).append(host);
            if (hasPort) {
                result.append(COLON).append(port);
            }
            result.append(appContext).append(SERVLET_PATH).append(SLASH).append(GENERATED_WSDL_FILENAME);
            result.append(QUESTION_MARK).append(SERVER_URL_KEY).append(EQUALS);
            Iterator iter = serverURLs.iterator();
            while (iter.hasNext()) {
                String serverURL = (String)iter.next();
                result.append(serverURL);
                if (!iter.hasNext()) continue;
                result.append(URLEncoder.encode(COMMA, "UTF-8"));
            }
            result.append(AMP).append(VDB_NAME_KEY).append(EQUALS).append(vdbName).append(AMP);
            if (hasVDBVersion) {
                result.append(VDB_VERSION_KEY).append(EQUALS).append(vdbVersion).append(AMP);
            }
            result.append(ADD_EXEC_PROPS).append(EQUALS).append(URLEncoder.encode("txnAutoWrap=" + txnAutoWrap, "UTF-8"));
        }
        catch (UnsupportedEncodingException err) {
            // empty catch block
        }
        return result.toString();
    }

    public static String formatURL(String scheme, String host, String port, String appContext, List serverURLs, String vdbName, String vdbVersion) {
        StringBuffer result = new StringBuffer();
        try {
            boolean hasPort = true;
            boolean hasVDBVersion = true;
            if (port == null || port.length() == 0) {
                hasPort = false;
            }
            if (vdbVersion == null || vdbVersion.trim().length() == 0) {
                hasVDBVersion = false;
            }
            result.append(scheme).append(COLON).append(DOUBLE_SLASH).append(host);
            if (hasPort) {
                result.append(COLON).append(port);
            }
            result.append(appContext).append(SERVLET_PATH).append(SLASH).append(GENERATED_WSDL_FILENAME);
            result.append(QUESTION_MARK).append(SERVER_URL_KEY).append(EQUALS);
            Iterator iter = serverURLs.iterator();
            while (iter.hasNext()) {
                String serverURL = (String)iter.next();
                result.append(serverURL);
                if (!iter.hasNext()) continue;
                result.append(URLEncoder.encode(COMMA, "UTF-8"));
            }
            result.append(AMP).append(VDB_NAME_KEY).append(EQUALS).append(vdbName);
            if (hasVDBVersion) {
                result.append(AMP).append(VDB_VERSION_KEY).append(EQUALS).append(vdbVersion);
            }
        }
        catch (UnsupportedEncodingException err) {
            // empty catch block
        }
        return result.toString();
    }

    public static String getSqlQueryWebServiceUrl(String server, String appContext, boolean secure) {
        appContext = _String.replace(appContext, SLASH, "");
        return MessageFormat.format(SQLQUERYWEBSERVICE_URL_FORMAT, secure ? HTTPS : HTTP, server, secure ? WSDLServletUtil.getHttpsPort() : WSDLServletUtil.getHttpPort(), appContext + SQLQUERYWEBSERVICE_WSDL_PATH);
    }

    public static final String getHttpsPort() {
        return System.getProperty(HTTPS_PORT_PROPERTY_KEY, DEFAULT_HTTPS_PORT);
    }

    public static final String getHttpPort() {
        return System.getProperty(HTTP_PORT_PROPERTY_KEY, DEFAULT_HTTP_PORT);
    }
}

