/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.id;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.id.ParsedObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.internal.core.id.EmbeddedUUIDFactory;

public class UUIDFactory
implements ObjectIDFactory {
    public static boolean DEBUG_UUID_FACTORY = false;
    private static EmbeddedUUIDFactory REAL_FACTORY;
    private static final Object LOCK;

    public UUIDFactory() {
        this.initializeEmbeddedFactory();
    }

    private final void initializeEmbeddedFactory() {
        if (REAL_FACTORY == null) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = LOCK;
                    synchronized (object) {
                        if (DEBUG_UUID_FACTORY) {
                            CorePlugin.Util.log(1, CorePlugin.Util.getString("UUIDFactory.UUID_Initializer_thread_running"));
                        }
                        if (REAL_FACTORY == null) {
                            if (DEBUG_UUID_FACTORY) {
                                CorePlugin.Util.log(1, CorePlugin.Util.getString("UUIDFactory.Instantiating_the_UUID_embedded_factory"));
                            }
                            REAL_FACTORY = new EmbeddedUUIDFactory();
                        }
                    }
                    if (DEBUG_UUID_FACTORY) {
                        CorePlugin.Util.log(1, CorePlugin.Util.getString("UUIDFactory.UUID_Initializer_thread_notifying_all"));
                    }
                    UUIDFactory.this.notifyMethod();
                }
            }.start();
        }
    }

    private synchronized void waitMethod() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private synchronized void notifyMethod() {
        this.notifyAll();
    }

    public String getDescription() {
        return CorePlugin.Util.getString("UUIDFactory.Description");
    }

    public boolean validate(ObjectID id) {
        if (id instanceof UUID) {
            return UUID.validate(id);
        }
        return false;
    }

    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        return UUID.stringToObject(value);
    }

    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmuuid");
        return UUID.stringToObject(parsedID.getRemainder());
    }

    public String getProtocol() {
        return "mmuuid";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCount() {
        Object object = LOCK;
        synchronized (object) {
            return REAL_FACTORY.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectID create() {
        if (REAL_FACTORY == null) {
            this.waitMethod();
        }
        Object object = LOCK;
        synchronized (object) {
            return REAL_FACTORY.create();
        }
    }

    static {
        LOCK = new Object();
    }
}

