/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.util.ArgCheck;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ChecksumOutputStream
extends OutputStream {
    private final Checksum checksum;
    private final OutputStream delegate;

    public ChecksumOutputStream(OutputStream delegate) {
        ArgCheck.isNotNull(delegate);
        this.delegate = delegate;
        this.checksum = new CRC32();
    }

    public long getChecksumValue() {
        return this.checksum.getValue();
    }

    public void write(int b) throws IOException {
        this.delegate.write(b);
        this.checksum.update(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.checksum.update(b, off, len);
    }
}

