/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.client.ConnectionInfo;
import com.metamatrix.dqp.client.impl.PortableStringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ServerConnectionInfo
implements ConnectionInfo {
    private static final String HEADER = "ServerConnectionInfo:";
    private String url;
    private String user;
    private String password;
    private Serializable trustedPayload;
    private String vdbName;
    private String vdbVersion;
    private Map optionalProperties;

    public ServerConnectionInfo() {
    }

    ServerConnectionInfo(String portableString) throws MetaMatrixProcessingException {
        String[] parts = PortableStringUtil.getParts(portableString, PortableStringUtil.PROP_SEPARATOR);
        if (parts == null || parts.length < 4 || parts.length > 7 || !parts[0].startsWith(HEADER)) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ServerConnectionInfo.invalid_context", portableString));
        }
        parts[0] = parts[0].substring(HEADER.length());
        this.url = PortableStringUtil.unescapeString(PortableStringUtil.getParts(parts[0], PortableStringUtil.EQUALS)[1]);
        this.user = PortableStringUtil.unescapeString(PortableStringUtil.getParts(parts[1], PortableStringUtil.EQUALS)[1]);
        this.password = PortableStringUtil.unescapeString(PortableStringUtil.getParts(parts[2], PortableStringUtil.EQUALS)[1]);
        this.vdbName = PortableStringUtil.unescapeString(PortableStringUtil.getParts(parts[3], PortableStringUtil.EQUALS)[1]);
        for (int i = 4; i < parts.length; ++i) {
            String[] propValPair = PortableStringUtil.getParts(parts[i], PortableStringUtil.EQUALS);
            try {
                if (propValPair[0].equals("VirtualDatabaseVersion")) {
                    this.vdbVersion = PortableStringUtil.unescapeString(propValPair[1]);
                    continue;
                }
                if (propValPair[0].equals("trustedPayload")) {
                    this.trustedPayload = (Serializable)PortableStringUtil.decode(propValPair[1]);
                    continue;
                }
                if (!propValPair[0].equals("optionalProperties")) continue;
                this.optionalProperties = (Map)PortableStringUtil.decode(propValPair[1]);
                continue;
            }
            catch (Exception e) {
                throw new MetaMatrixProcessingException((Throwable)e, DQPPlugin.Util.getString("ServerConnectionInfo.invalid_encoding", propValPair[1]));
            }
        }
    }

    String getServerUrl() {
        return this.url;
    }

    public void setServerUrl(String url) {
        this.url = url;
    }

    String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    Serializable getTrustedPayload() {
        return this.trustedPayload;
    }

    public void setTrustedPayload(Serializable trustedPayload) {
        this.trustedPayload = trustedPayload;
    }

    String getVDBName() {
        return this.vdbName;
    }

    public void setVDBName(String vdbName) {
        this.vdbName = vdbName;
    }

    String getVDBVersion() {
        return this.vdbVersion;
    }

    public void setVDBVersion(String vdbVersion) {
        this.vdbVersion = vdbVersion != null && vdbVersion.length() != 0 ? vdbVersion : null;
    }

    Map getOptionalProperties() {
        return this.optionalProperties;
    }

    public void setOptionalProperty(String propName, Object propValue) {
        if (this.optionalProperties == null) {
            this.optionalProperties = new HashMap();
        }
        this.optionalProperties.put(propName, propValue);
    }

    Properties getConnectionProperties() {
        Properties props = new Properties();
        props.setProperty("serverURL", this.url);
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        props.setProperty("VirtualDatabaseName", this.vdbName);
        props.setProperty("vdbName", this.vdbName);
        if (this.vdbVersion != null && this.vdbVersion.length() != 0) {
            props.setProperty("VirtualDatabaseVersion", this.vdbVersion);
            props.setProperty("vdbVersion", this.vdbVersion);
        }
        this.setHostAndPort(props, this.url);
        if (this.trustedPayload != null) {
            props.put("trustedPayload", this.trustedPayload);
        }
        if (this.optionalProperties != null && !this.optionalProperties.isEmpty()) {
            props.putAll((Map<?, ?>)this.optionalProperties);
        }
        return props;
    }

    public int hashCode() {
        int hash = HashCodeUtil.hashCode(0, this.url);
        hash = HashCodeUtil.hashCode(hash, this.user);
        hash = HashCodeUtil.hashCode(hash, this.password);
        hash = HashCodeUtil.hashCode(hash, this.vdbName);
        if (this.vdbVersion != null && this.vdbVersion.length() != 0) {
            return HashCodeUtil.hashCode(hash, this.vdbVersion);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServerConnectionInfo)) {
            return false;
        }
        ServerConnectionInfo info = (ServerConnectionInfo)obj;
        return EquivalenceUtil.areEqual(this.url, info.url) && EquivalenceUtil.areEqual(this.user, info.user) && EquivalenceUtil.areEqual(this.password, info.password) && EquivalenceUtil.areEqual(this.vdbName, info.vdbName) && EquivalenceUtil.areEqual(this.vdbVersion, info.vdbVersion) && EquivalenceUtil.areEqual(this.trustedPayload, info.trustedPayload) && EquivalenceUtil.areEqual(this.optionalProperties, info.optionalProperties);
    }

    String getPortableString() {
        String encodedString;
        StringBuffer buf = new StringBuffer(HEADER).append("serverURL").append(PortableStringUtil.EQUALS).append(PortableStringUtil.escapeString(this.url)).append(PortableStringUtil.PROP_SEPARATOR).append("user").append(PortableStringUtil.EQUALS).append(PortableStringUtil.escapeString(this.user)).append(PortableStringUtil.PROP_SEPARATOR).append("password").append(PortableStringUtil.EQUALS).append(PortableStringUtil.escapeString(this.password)).append(PortableStringUtil.PROP_SEPARATOR).append("VirtualDatabaseName").append(PortableStringUtil.EQUALS).append(PortableStringUtil.escapeString(this.vdbName));
        if (this.vdbVersion != null && this.vdbVersion.length() != 0) {
            buf.append(PortableStringUtil.PROP_SEPARATOR).append("VirtualDatabaseVersion").append(PortableStringUtil.EQUALS).append(PortableStringUtil.escapeString(this.vdbVersion));
        }
        if (this.trustedPayload != null) {
            try {
                encodedString = PortableStringUtil.encode(this.trustedPayload);
                buf.append(PortableStringUtil.PROP_SEPARATOR).append("trustedPayload").append(PortableStringUtil.EQUALS).append(encodedString);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.optionalProperties != null && !this.optionalProperties.isEmpty()) {
            try {
                encodedString = PortableStringUtil.encode(this.optionalProperties);
                buf.append(PortableStringUtil.PROP_SEPARATOR).append("optionalProperties").append(PortableStringUtil.EQUALS).append(encodedString);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    private void setHostAndPort(Properties props, String url) {
        String[] parts = PortableStringUtil.getParts(url, ':');
        if (parts == null || parts.length != 3 || !parts[1].startsWith("//")) {
            throw new IllegalArgumentException(DQPPlugin.Util.getString("ServerConnectionInfo.invalid_url"));
        }
        parts[1] = parts[1].substring(2);
        props.setProperty("host", parts[1]);
        props.setProperty("port", parts[2]);
    }
}

