/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.util;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.DriverManager;
import java.sql.Timestamp;

public class JDBCTraceLogger
implements InvocationHandler {
    private Object delegate;
    private String delegateName;
    private PrintWriter logWriter;
    private static final String ENTRY = "ENTRY";
    private static final String EXIT = "EXIT";

    public JDBCTraceLogger(Object obj, PrintWriter logWriter) {
        this.logWriter = logWriter;
        this.delegate = obj;
        String delegateClassName = obj.getClass().getName();
        int baseNameIndex = delegateClassName.lastIndexOf(46);
        this.delegateName = baseNameIndex >= 0 ? delegateClassName.substring(baseNameIndex + 1) : delegateClassName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.logTrace(ENTRY, this.delegateName, method.getName(), args);
        Object result = null;
        try {
            result = method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.logTrace(EXIT, this.delegateName, method.getName(), args);
        }
        return result;
    }

    private void logTrace(String point, String className, String methodName, Object[] args) {
        StringBuffer traceMsg = new StringBuffer(new Timestamp(System.currentTimeMillis()).toString());
        traceMsg.append(": TRACE-");
        traceMsg.append(point);
        traceMsg.append(' ');
        traceMsg.append(className);
        traceMsg.append('.');
        traceMsg.append(methodName);
        traceMsg.append('(');
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                traceMsg.append(args[i]);
                traceMsg.append(", ");
            }
            if (args.length > 0) {
                traceMsg.setLength(traceMsg.length() - 2);
            }
        }
        traceMsg.append(')');
        if (this.logWriter != null) {
            this.logWriter.println(traceMsg);
        } else {
            DriverManager.println(traceMsg.toString());
        }
    }

    public static Object newInstance(Object obj, Class[] interfaces, PrintWriter logWriter) {
        JDBCTraceLogger aLogger = new JDBCTraceLogger(obj, logWriter);
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), interfaces, (InvocationHandler)aLogger);
    }
}

