/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import java.io.Serializable;

public class MetaMatrixPrincipalName
implements Serializable {
    private int type;
    private String name;

    public MetaMatrixPrincipalName(String name, int type) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0056"));
        }
        if (name.trim().length() > 1024) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0057", 1024));
        }
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0058"));
        }
        this.name = name;
        this.type = type;
    }

    protected MetaMatrixPrincipalName(MetaMatrixPrincipalName obj) {
        if (obj == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0059"));
        }
        this.type = obj.getType();
        this.name = obj.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            MetaMatrixPrincipalName that = (MetaMatrixPrincipalName)obj;
            if (this.type == that.type && this.name.compareTo(that.name) == 0) {
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object obj) {
        MetaMatrixPrincipalName that = (MetaMatrixPrincipalName)obj;
        if (obj == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0060"));
        }
        int comp = this.name.compareTo(that.name);
        if (comp == 0) {
            comp = this.type - that.type;
        }
        return comp;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeLabel() {
        return MetaMatrixPrincipal.TYPE_NAMES[this.type];
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Name=\"");
        sb.append(this.getName());
        sb.append("\" - Type=\"");
        sb.append(MetaMatrixPrincipal.TYPE_NAMES[this.type]);
        sb.append("\"]");
        return sb.toString();
    }

    public Object clone() {
        return new MetaMatrixPrincipalName(this);
    }
}

