/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CommandContainer;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BatchedUpdateCommand
extends Command
implements CommandContainer {
    protected List commands;

    public void addSubCommand(Command command) {
        if (this.commands == null) {
            this.commands = new ArrayList();
        }
        this.commands.add(command);
    }

    public void addSubCommands(Collection commands) {
        if (commands == null || commands.size() == 0) {
            return;
        }
        if (this.commands == null) {
            this.commands = new ArrayList();
        }
        this.commands.addAll(commands);
    }

    public List getSubCommands() {
        if (this.commands == null || this.commands.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return this.commands;
    }

    public BatchedUpdateCommand(List updateCommands) {
        this.addSubCommands(updateCommands);
    }

    public List getUpdateCommands() {
        return this.getSubCommands();
    }

    public int getType() {
        return 9;
    }

    public List getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        int sunCommandUpdatingModelCount = 0;
        if (this.commands != null && !this.commands.isEmpty()) {
            Object sourceModel = null;
            Iterator iter = this.commands.iterator();
            while (iter.hasNext()) {
                Command command = (Command)iter.next();
                GroupSymbol group = null;
                if (command.getType() == 2) {
                    group = ((Insert)command).getGroup();
                } else if (command.getType() == 3) {
                    group = ((Update)command).getGroup();
                } else if (command.getType() == 4) {
                    group = ((Delete)command).getGroup();
                } else {
                    sunCommandUpdatingModelCount += command.updatingModelCount(metadata);
                }
                if (group != null) {
                    try {
                        if (sourceModel == null) {
                            sourceModel = metadata.getModelID(group.getMetadataID());
                            ++sunCommandUpdatingModelCount;
                            continue;
                        }
                        if (!sourceModel.equals(metadata.getModelID(group.getMetadataID()))) {
                            return 2;
                        }
                    }
                    catch (QueryMetadataException qme) {
                        throw new MetaMatrixComponentException((Throwable)qme);
                    }
                }
                if (sunCommandUpdatingModelCount <= 1) continue;
                break;
            }
        }
        return sunCommandUpdatingModelCount;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        ArrayList<Object> clonedCommands = new ArrayList<Object>(this.commands.size());
        for (int i = 0; i < this.commands.size(); ++i) {
            clonedCommands.add(((Command)this.commands.get(i)).clone());
        }
        BatchedUpdateCommand copy = new BatchedUpdateCommand(clonedCommands);
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean areResultsCachable() {
        return false;
    }

    public String toString() {
        StringBuffer val = new StringBuffer("BatchedUpdate{");
        if (this.commands != null && this.commands.size() > 0) {
            val.append(this.getCommandToken((Command)this.commands.get(0)));
            for (int i = 1; i < this.commands.size(); ++i) {
                val.append(',').append(this.getCommandToken((Command)this.commands.get(i)));
            }
        }
        val.append('}');
        return val.toString();
    }

    private char getCommandToken(Command command) {
        int commandType = command.getType();
        if (commandType == 2) {
            return 'I';
        }
        if (commandType == 3) {
            return 'U';
        }
        if (commandType == 4) {
            return 'D';
        }
        if (commandType == 1) {
            return 'S';
        }
        return '?';
    }

    public List getContainedCommands() {
        return this.getSubCommands();
    }
}

