/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.proc;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;

public class AssignmentStatement
extends Statement
implements SubqueryContainer {
    private ElementSymbol variable;
    private LanguageObject value;

    public AssignmentStatement() {
    }

    public AssignmentStatement(ElementSymbol variable, LanguageObject value) {
        this.variable = variable;
        if (value instanceof ScalarSubquery) {
            ScalarSubquery scalarSubquery = (ScalarSubquery)value;
            value = scalarSubquery.getCommand();
        }
        this.value = value;
    }

    public boolean hasCommand() {
        return this.value instanceof Command;
    }

    public Command getCommand() {
        if (this.hasCommand()) {
            return (Command)this.value;
        }
        return null;
    }

    public void setCommand(Command command) {
        this.value = command;
    }

    public boolean hasExpression() {
        return this.value instanceof Expression;
    }

    public Expression getExpression() {
        if (this.hasExpression()) {
            return (Expression)this.value;
        }
        return null;
    }

    public void setExpression(Expression expression) {
        this.value = expression;
    }

    public LanguageObject getValue() {
        return this.value;
    }

    public void setValue(LanguageObject value) {
        this.value = value;
    }

    public ElementSymbol getVariable() {
        return this.variable;
    }

    public void setVariable(ElementSymbol variable) {
        this.variable = variable;
    }

    public int getType() {
        return 5;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        AssignmentStatement clone = new AssignmentStatement((ElementSymbol)this.variable.clone(), (LanguageObject)this.value.clone());
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AssignmentStatement other = (AssignmentStatement)obj;
        return EquivalenceUtil.areEqual(this.getVariable(), other.getVariable()) && EquivalenceUtil.areEqual(this.getValue(), other.getValue());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.getVariable());
        myHash = HashCodeUtil.hashCode(myHash, this.getValue());
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

