/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;

public class Function
implements Expression {
    private String name;
    private Expression[] args;
    private Class type;
    private FunctionDescriptor descriptor;
    private boolean implicit = false;

    public Function(String name, Expression[] args) {
        this.name = name;
        this.args = args;
    }

    public String getName() {
        return this.name;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public Expression getArg(int index) {
        return this.args[index];
    }

    public void setArgs(Expression[] args) {
        this.args = args;
    }

    public void makeImplicit() {
        this.implicit = true;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void insertConversion(int index, FunctionDescriptor functionDescriptor) {
        Class type = functionDescriptor.getReturnType();
        String typeName = DataTypeManager.getDataTypeName(type);
        Expression[] newArg = new Expression[]{this.args[index], new Constant(typeName)};
        Function func = new Function(functionDescriptor.getName(), newArg);
        this.args[index] = func;
        func.setFunctionDescriptor(functionDescriptor);
        func.setType(type);
        func.makeImplicit();
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.descriptor;
    }

    public void setFunctionDescriptor(FunctionDescriptor fd) {
        this.descriptor = fd;
    }

    public boolean isResolved() {
        boolean resolved = true;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].isResolved()) continue;
            resolved = false;
        }
        return resolved;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        if (!other.getName().equalsIgnoreCase(this.getName())) {
            return false;
        }
        Expression[] otherArgs = other.getArgs();
        Expression[] thisArgs = this.getArgs();
        if (otherArgs == null) {
            if (thisArgs != null) {
                return false;
            }
        } else {
            if (thisArgs == null) {
                return false;
            }
            if (thisArgs.length != otherArgs.length) {
                return false;
            }
            for (int i = 0; i < thisArgs.length; ++i) {
                if (EquivalenceUtil.areEqual(thisArgs[i], otherArgs[i])) continue;
                return false;
            }
        }
        return this.isImplicit() == other.isImplicit();
    }

    public int hashCode() {
        int hashCode = HashCodeUtil.hashCode(0, this.getName().toUpperCase());
        Expression[] thisArgs = this.getArgs();
        if (thisArgs != null && thisArgs.length > 0 && thisArgs[0] != null) {
            hashCode = HashCodeUtil.hashCode(hashCode, thisArgs[0].hashCode());
        }
        return hashCode;
    }

    public Object clone() {
        Expression[] args = this.getArgs();
        Expression[] copyArgs = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            copyArgs[i] = (Expression)args[i].clone();
        }
        Function copy = new Function(this.getName(), copyArgs);
        copy.setType(this.getType());
        copy.setFunctionDescriptor(this.getFunctionDescriptor());
        if (this.isImplicit()) {
            copy.makeImplicit();
        }
        return copy;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

