/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;

public abstract class Symbol
implements LanguageObject {
    private String name;
    private String canonicalName;
    private int hash;
    private String fullyQualifiedName;

    protected Symbol(String name, String canonicalName, int hashcode) {
        this.name = name;
        this.canonicalName = canonicalName;
        this.hash = hashcode;
    }

    public Symbol(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0017"));
        }
        this.name = name;
        this.canonicalName = null;
    }

    public String getName() {
        return this.name;
    }

    public String getCanonicalName() {
        this.computeCanonicalNameAndHash();
        return this.canonicalName;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void setFullyQualifiedName(String qName) {
        this.fullyQualifiedName = qName;
    }

    public abstract boolean isResolved();

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public int hashCode() {
        this.computeCanonicalNameAndHash();
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass().equals(obj.getClass())) {
            return ((Symbol)obj).getCanonicalName().equals(this.getCanonicalName());
        }
        return false;
    }

    public abstract Object clone();

    protected String getCanonical() {
        return this.canonicalName;
    }

    protected int getHash() {
        return this.hash;
    }

    private void computeCanonicalNameAndHash() {
        if (this.canonicalName == null) {
            this.canonicalName = StringUtil.toUpperCase(this.name);
            this.hash = this.canonicalName.hashCode();
        }
    }
}

