/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import java.util.ArrayList;
import java.util.List;

public class ReferenceBindingReplacerVisitor
extends LanguageVisitor {
    private List parsedBindingExpressions;

    public ReferenceBindingReplacerVisitor(List parsedBindingExpressions) {
        this.parsedBindingExpressions = parsedBindingExpressions;
    }

    public void visit(BetweenCriteria obj) {
        Expression upperExpression;
        Expression lowerExpression;
        Expression expression = obj.getExpression();
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            obj.setExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
        if ((lowerExpression = obj.getLowerExpression()) instanceof Reference) {
            Reference ref = (Reference)lowerExpression;
            obj.setLowerExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
        if ((upperExpression = obj.getUpperExpression()) instanceof Reference) {
            Reference ref = (Reference)upperExpression;
            obj.setUpperExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
    }

    public void visit(CaseExpression obj) {
        obj.setExpression(this.replaceReference(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.replaceReference(obj.getWhenExpression(i)));
            thens.add(this.replaceReference(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.replaceReference(obj.getElseExpression()));
        }
    }

    public void visit(CompareCriteria obj) {
        Expression rightExpression;
        Expression leftExpression = obj.getLeftExpression();
        if (leftExpression instanceof Reference) {
            Reference ref = (Reference)leftExpression;
            obj.setLeftExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
        if ((rightExpression = obj.getRightExpression()) instanceof Reference) {
            Reference ref = (Reference)rightExpression;
            obj.setRightExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
    }

    public void visit(Function obj) {
        int argLength = obj.getArgs().length;
        Expression[] args = new Expression[argLength];
        for (int i = 0; i < argLength; ++i) {
            args[i] = this.replaceReference(obj.getArg(i));
        }
        obj.setArgs(args);
    }

    public void visit(IsNullCriteria obj) {
        Expression exp = obj.getExpression();
        if (exp instanceof Reference) {
            Reference ref = (Reference)exp;
            obj.setExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
    }

    public void visit(MatchCriteria obj) {
        Expression rightExpression;
        Expression leftExpression = obj.getLeftExpression();
        if (leftExpression instanceof Reference) {
            Reference ref = (Reference)leftExpression;
            obj.setLeftExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
        if ((rightExpression = obj.getRightExpression()) instanceof Reference) {
            Reference ref = (Reference)rightExpression;
            obj.setRightExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.replaceReference(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.replaceReference(obj.getElseExpression()));
        }
    }

    public void visit(SetCriteria obj) {
        Expression exp = obj.getExpression();
        if (exp instanceof Reference) {
            Reference ref = (Reference)exp;
            obj.setExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
    }

    public void visit(DependentSetCriteria obj) {
        Expression exp = obj.getExpression();
        if (exp instanceof Reference) {
            Reference ref = (Reference)exp;
            obj.setExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
    }

    public void visit(SubquerySetCriteria obj) {
        Expression exp = obj.getExpression();
        if (exp instanceof Reference) {
            Reference ref = (Reference)exp;
            obj.setExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
    }

    public void visit(SubqueryCompareCriteria obj) {
        Expression leftExpression = obj.getLeftExpression();
        if (leftExpression instanceof Reference) {
            Reference ref = (Reference)leftExpression;
            obj.setLeftExpression((Expression)this.parsedBindingExpressions.get(ref.getIndex()));
        }
    }

    private Expression replaceReference(Expression expr) {
        if (expr instanceof Reference) {
            Reference ref = (Reference)expr;
            expr = (Expression)this.parsedBindingExpressions.get(ref.getIndex());
        }
        return expr;
    }

    public static final void replaceReferences(LanguageObject obj, List parsedBindingExpressions) {
        ReferenceBindingReplacerVisitor visitor = new ReferenceBindingReplacerVisitor(parsedBindingExpressions);
        PreOrderNavigator.doVisit(obj, visitor);
    }
}

