/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.IBuddyPolicy;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class DependentPolicy
implements IBuddyPolicy {
    BundleLoader buddyRequester;
    int lastDependentOfAdded = -1;
    List allDependents = null;

    public DependentPolicy(BundleLoader requester) {
        this.buddyRequester = requester;
        this.allDependents = new ArrayList();
        this.basicAddImmediateDependents(this.buddyRequester.getBundle().getBundleDescription());
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    public Class loadClass(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Class result = null;
        for (int i = 0; i < this.allDependents.size() && result == null; ++i) {
            BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i);
            try {
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
                if (proxy == null) continue;
                result = proxy.getBundleLoader().findClass(name, true);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (result != null) continue;
                this.addDependent(i, searchedBundle);
            }
        }
        return result;
    }

    private synchronized void addDependent(int i, BundleDescription searchedBundle) {
        if (i > this.lastDependentOfAdded) {
            this.lastDependentOfAdded = i;
            this.basicAddImmediateDependents(searchedBundle);
        }
    }

    public URL loadResource(String name) {
        if (this.allDependents == null) {
            return null;
        }
        URL result = null;
        for (int i = 0; i < this.allDependents.size() && result == null; ++i) {
            BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i);
            BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
            if (proxy == null || (result = proxy.getBundleLoader().findResource(name, true)) != null) continue;
            this.addDependent(i, searchedBundle);
        }
        return result;
    }

    public Enumeration loadResources(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Enumeration result = null;
        for (int i = 0; i < this.allDependents.size() && result == null; ++i) {
            BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i);
            try {
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
                if (proxy == null) continue;
                result = proxy.getBundleLoader().findResources(name);
            }
            catch (IOException e) {
                continue;
            }
            if (result != null) continue;
            this.addDependent(i, searchedBundle);
        }
        return result;
    }

    private void basicAddImmediateDependents(BundleDescription root) {
        BundleDescription[] dependents = root.getDependents();
        for (int i = 0; i < dependents.length; ++i) {
            BundleDescription toAdd = dependents[i];
            if (toAdd.getHost() != null || this.allDependents.contains(toAdd)) continue;
            this.allDependents.add(toAdd);
        }
    }
}

