/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplResultSetService;
import com.metamatrix.jdbc.base.BaseResultSet;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideSensitive
extends BaseImplResultSetService {
    private static String footprint = "$Revision:   1.11.1.0  $";
    private BaseConnection connection;
    private UtilVectorUnsynced keyset;
    private PreparedStatement fetchStatement;
    private String targetTable;
    private String rowid;
    private int rowidOrdinal;
    private String originalSelectList;
    private boolean onDeletedRow;

    BaseImplResultSetClientSideSensitive(BaseConnection baseConnection, String string, String string2, String string3, int n) {
        this.connection = baseConnection;
        this.targetTable = string;
        this.originalSelectList = string2;
        this.rowid = string3;
        this.rowidOrdinal = n;
    }

    public int getScrollType() {
        return 1005;
    }

    public void close() throws SQLException {
        if (this.fetchStatement != null) {
            this.fetchStatement.close();
            this.fetchStatement = null;
            this.subImplResultSet = null;
        }
        super.close();
        this.keyset = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetupInitialize() throws SQLException {
        super.postSetupInitialize();
        int n = 0;
        this.keyset = new UtilVectorUnsynced();
        while (this.subImplResultSet.fetchAtPosition(n + 1)) {
            this.keyset.addElement(this.subImplResultSet.getData(this.rowidOrdinal, 10).getObject());
            if (this.maxCursorPosition != -1 && ++n == this.maxCursorPosition) break;
        }
        this.subImplResultSet.close();
        this.subImplResultSet = null;
        this.maxCursorPosition = n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append(this.originalSelectList);
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.targetTable);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(this.rowid);
        stringBuffer.append(" = ?");
        try {
            this.connection.prepareExecuteMode = 2;
            this.fetchStatement = this.connection.prepareStatement(stringBuffer.toString());
            Object var4_3 = null;
            this.connection.prepareExecuteMode = 0;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.connection.prepareExecuteMode = 0;
            throw throwable;
        }
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        try {
            if (this.keyset.size() == 0) {
                return false;
            }
            this.onDeletedRow = false;
            this.fetchStatement.setObject(1, this.keyset.elementAt(n - 1));
            this.subImplResultSet = null;
            this.connection.prepareExecuteMode = 2;
            BaseResultSet baseResultSet = (BaseResultSet)this.fetchStatement.executeQuery();
            if (baseResultSet.next()) {
                this.subImplResultSet = baseResultSet.implResultSet;
            } else {
                this.onDeletedRow = true;
            }
        }
        catch (SQLException sQLException) {
            this.connection.prepareExecuteMode = 0;
            throw sQLException;
        }
        return true;
    }

    protected void refreshRow() throws SQLException {
        this.fetchAtPosition(this.cursorPosition);
    }

    public boolean onDeletedRow() throws SQLException {
        return this.onDeletedRow;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        return this.subImplResultSet.getData(n, n2);
    }
}

