/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.oracle.OracleEscapeTranslator;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.OracleImplDatabaseMetaData;
import java.sql.SQLException;

public class OracleConnection
extends BaseConnection {
    private static String footprint = "$Revision:   3.20.1.0  $";
    public OracleImplDatabaseMetaData oidm = null;
    public OracleImplConnection oic = null;

    protected void getImplPropertyInfo(BaseDriverPropertyInfos baseDriverPropertyInfos) {
        baseDriverPropertyInfos.put("user", "Oracle user", "", null, false);
        baseDriverPropertyInfos.put("password", "Oracle Password", "", null, false);
        baseDriverPropertyInfos.put("serverName", "Database Server Host Name", "", null, false);
        baseDriverPropertyInfos.put("portNumber", "Database Server Port Number", "1521", null, false);
        baseDriverPropertyInfos.put("SID", "Oracle SID", "", null, false);
        baseDriverPropertyInfos.put("refCursorSupport", "REFCURSOR variables returned as multiple result sets", "true", null, false);
        baseDriverPropertyInfos.put("FetchTSWTZasTimestamp", "turn on to fetch TIMESTAMP WITH TIMEZONES values as timestamps", "false", null, false);
        baseDriverPropertyInfos.put("CatalogIncludesSynonyms", "return (proc)column and Indexinfo for synonyms (slower)", "true", null, false);
        baseDriverPropertyInfos.put("CatalogOptions", "integer bitmask configuring the DatabaseMetadata catalog resultsets", "2", null, false);
        baseDriverPropertyInfos.put("serviceName", "Oracle service name", "", null, false);
        baseDriverPropertyInfos.put("TNSNamesFile", "Fully qualified path of the file containing TNS name information. Typically, this file is named TNSNAMES.ORA", "", null, false);
        baseDriverPropertyInfos.put("TNSServerName", "The name of the entry within the TNSNamesFile to be used for connection information", "", null, false);
        baseDriverPropertyInfos.put("codePageOverride", "Code page override", "", null, false);
        baseDriverPropertyInfos.put("enableCancelTimeout", "Enable Cancel Timeout", "false", null, false);
        baseDriverPropertyInfos.put("sendFloatParametersAsString", "Indicates whether float/real/double parameters are to be sent to the server in string format", "false", null, false);
        baseDriverPropertyInfos.put("supportLinks", "Indicates whether the application intends to use Oracle database links", "false", null, false);
        String[] stringArray = new String[]{"1", "2"};
        baseDriverPropertyInfos.put("wireProtocolMode", "Indicates whether the driver should optimize for repeating result set data (2) or non-repeating result set data (1)", "1", stringArray, false);
        String[] stringArray2 = new String[]{"", "dedicated", "shared"};
        baseDriverPropertyInfos.put("serverType", "Determines whether a connection is established to a dedicated or shared server process", "", stringArray2, false);
        String[] stringArray3 = new String[]{"auto", "type4", "type2", "client", "none"};
        baseDriverPropertyInfos.put("authenticationMethod", "Authentication method used to connect", "auto", stringArray3, false);
    }

    public boolean getBatchIsJDBCCompliant() {
        return false;
    }

    public BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        this.oidm = new OracleImplDatabaseMetaData();
        if (this.oic != null) {
            this.oidm.oic = this.oic;
            this.oidm.databaseProductVersion = this.oic.oracleServerVersionString;
            int n = (int)(this.oic.oracleServerVersion / 100000000L);
            this.oidm.databaseMajorVersion = new Integer(n);
            n = (int)((this.oic.oracleServerVersion - (long)(n * 100000000)) / 1000000L);
            this.oidm.databaseMinorVersion = new Integer(n);
        }
        return this.oidm;
    }

    protected BaseImplConnection createImplConnection(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        this.oic = new OracleImplConnection(this);
        return this.oic;
    }

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return new OracleEscapeTranslator(this.oic);
    }
}

