/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCRequest;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

public class TDSRPCCallRequest
extends TDSRPCRequest {
    private static String footprint = "$Revision:   3.3.1.1  $";
    private String procName;
    private boolean callHasReturnParam;

    public TDSRPCCallRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, String string, boolean bl) {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter);
        this.procName = string;
        this.callHasReturnParam = bl;
    }

    public void createUserParameters(UtilVectorUnsynced utilVectorUnsynced, int n, boolean bl, int n2) {
        this.baseParamSets = utilVectorUnsynced;
        this.maxPrecision = n;
        this.sendStringParametersAsUnicode = bl;
        this.receiveStringParameterType = n2;
        if (utilVectorUnsynced == null) {
            return;
        }
        BaseParameters baseParameters = (BaseParameters)utilVectorUnsynced.get(0);
        int n3 = baseParameters.count();
        int n4 = 1;
        while (n4 <= n3) {
            if (n4 != 1 || !this.callHasReturnParam) {
                this.addUserParameter(new TDSRPCParameter(this.conn.getTDSVersion(), n, this.conn.exceptions, this.conn.connection));
            }
            ++n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        this.reset();
        if (this.baseParamSets != null && this.baseParamSets.size() > 1) {
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                int n = 0;
                while (n < this.baseParamSets.size()) {
                    this.addRPCToBatch(this.procName, 0);
                    try {
                        this.processUserParameters((BaseParameters)this.baseParamSets.get(n));
                        this.addUserParametersToRPC();
                        this.encodeRPCCall(n == 0);
                    }
                    catch (SQLException sQLException) {
                        this.removeLastRPCFromBatch();
                        throw sQLException;
                    }
                    ++n;
                }
            }
        }
        this.addRPCToBatch(this.procName, 0);
        if (this.baseParamSets != null) {
            this.processUserParameters((BaseParameters)this.baseParamSets.get(0));
        }
        this.addUserParametersToRPC();
        this.submitRequest(sQLServerImplStatement);
    }

    private void processUserParameters(BaseParameters baseParameters) throws SQLException {
        if (baseParameters == null) {
            return;
        }
        int n = baseParameters.count();
        TDSRPCParameter tDSRPCParameter = null;
        int n2 = 1;
        while (n2 <= n) {
            if (n2 != 1 || !this.callHasReturnParam) {
                tDSRPCParameter = this.callHasReturnParam ? (TDSRPCParameter)this.userParameters.get(n2 - 2) : (TDSRPCParameter)this.userParameters.get(n2 - 1);
                tDSRPCParameter.initializeUserParam(n2, baseParameters, this.sendStringParametersAsUnicode, this.receiveStringParameterType);
            }
            ++n2;
        }
    }
}

