/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import COM.rsa.jsafe.JSAFE_InvalidKeyException;
import COM.rsa.jsafe.JSAFE_PrivateKey;
import COM.rsa.jsafe.JSAFE_UnimplementedException;
import com.metamatrix.sequelink.security.Message;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.X509EncodedKeySpec;

final class JSafeRSAPrivateKey
implements RSAPrivateKey {
    private static final String JSAFE_RSA_PRIVATEKEY_FORMAT = "RSAPrivateKey";
    private static final String JSAFE_RSA_ENC_PRIVATEKEY_FORMAT = "RSAPrivateKeyBER";
    private static final String JSAFE_RSA_KEY_ALG = "RSA";
    private static final String JSAFE_DEVICE = "Java";
    private JSAFE_PrivateKey privateKey;
    private BigInteger modulus;
    private BigInteger privateExponent;

    JSafeRSAPrivateKey(RSAPrivateKeySpec rSAPrivateKeySpec) {
        this.modulus = rSAPrivateKeySpec.getModulus();
        this.privateExponent = rSAPrivateKeySpec.getPrivateExponent();
        try {
            this.privateKey = JSAFE_PrivateKey.getInstance((String)JSAFE_RSA_KEY_ALG, (String)JSAFE_DEVICE);
            byte[][] byArrayArray = new byte[][]{this.modulus.toByteArray(), this.privateExponent.toByteArray()};
            this.privateKey.setKeyData(JSAFE_RSA_PRIVATEKEY_FORMAT, (byte[][])byArrayArray);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(Message.Gen.getException(7647, jSAFE_UnimplementedException.toString()));
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(Message.Gen.getException(7647, jSAFE_InvalidKeyException.toString()));
        }
    }

    JSafeRSAPrivateKey(X509EncodedKeySpec x509EncodedKeySpec) throws InvalidKeySpecException {
        try {
            this.privateKey = JSAFE_PrivateKey.getInstance((byte[])x509EncodedKeySpec.getEncoded(), (int)0, (String)JSAFE_DEVICE);
            byte[][] byArray = this.privateKey.getKeyData(JSAFE_RSA_PRIVATEKEY_FORMAT);
            this.modulus = new BigInteger(byArray[0]);
            this.privateExponent = new BigInteger(byArray[1]);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(Message.Gen.getException(7647, jSAFE_UnimplementedException.toString()));
        }
    }

    JSafeRSAPrivateKey(PKCS8EncodedKeySpec pKCS8EncodedKeySpec) throws InvalidKeySpecException {
        try {
            ASN1 aSN1 = new ASN1(pKCS8EncodedKeySpec.getEncoded());
            ASN1Object aSN1Object = aSN1.toASN1Object();
            if (!(aSN1Object instanceof SEQUENCE)) {
                throw new InvalidKeySpecException(Message.Gen.getException(7660));
            }
            if (!((aSN1Object = ((SEQUENCE)aSN1Object).getComponentAt(2)) instanceof OCTET_STRING)) {
                throw new InvalidKeySpecException(Message.Gen.getException(7660));
            }
            byte[] byArray = ((OCTET_STRING)aSN1Object).getWholeValue();
            aSN1 = new ASN1(byArray);
            if (!((aSN1Object = aSN1.toASN1Object()) instanceof SEQUENCE)) {
                throw new InvalidKeySpecException(Message.Gen.getException(7660));
            }
            ASN1Object aSN1Object2 = ((SEQUENCE)aSN1Object).getComponentAt(1);
            ASN1Object aSN1Object3 = ((SEQUENCE)aSN1Object).getComponentAt(3);
            if (!(aSN1Object2 instanceof INTEGER) || !(aSN1Object3 instanceof INTEGER)) {
                throw new InvalidKeySpecException(Message.Gen.getException(7660));
            }
            this.modulus = (BigInteger)((INTEGER)aSN1Object2).getValue();
            this.privateExponent = (BigInteger)((INTEGER)aSN1Object3).getValue();
            this.privateKey = JSAFE_PrivateKey.getInstance((String)JSAFE_RSA_KEY_ALG, (String)JSAFE_DEVICE);
            byte[][] byArrayArray = new byte[][]{this.modulus.toByteArray(), this.privateExponent.toByteArray()};
            this.privateKey.setKeyData(JSAFE_RSA_PRIVATEKEY_FORMAT, (byte[][])byArrayArray);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(Message.Gen.getException(7647, jSAFE_InvalidKeyException.toString()));
        }
        catch (CodingException codingException) {
            throw new InvalidKeySpecException(Message.Gen.getException(7661, codingException.toString()));
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(Message.Gen.getException(7661, iOException.toString()));
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(Message.Gen.getException(7647, jSAFE_UnimplementedException.toString()));
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public String getAlgorithm() {
        return JSAFE_RSA_KEY_ALG;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        try {
            byte[][] byArray = this.privateKey.getKeyData(JSAFE_RSA_ENC_PRIVATEKEY_FORMAT);
            return byArray[0];
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(Message.Gen.getException(7647, jSAFE_UnimplementedException.toString()));
        }
    }

    JSAFE_PrivateKey getJSafePrivateKey() {
        return this.privateKey;
    }
}

