/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase.tds;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCommunication;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSRequest;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSnoopIndirection;
import java.net.Socket;
import java.sql.SQLException;

public class SybaseTDSLoginRequest
extends SybaseTDSRequest {
    private static String footprint = "$Revision:   3.9.1.0  $";
    private String username;
    private String password;
    private byte[] capabilityRequest = null;
    private byte[] capabilityResponse = null;
    public int majorServerVersion;
    public int minorServerVersion;

    public SybaseTDSLoginRequest(SybaseTDSCommunication sybaseTDSCommunication, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, String string, String string2) {
        super(sybaseTDSCommunication, utilByteOrderedDataReader, utilByteOrderedDataWriter, 2);
        this.username = string;
        this.password = string2;
    }

    public void submitRequest() throws SQLException {
        try {
            this.clearReplyChannel();
            this.comm.setMessageType(this.messageType);
            this.setupLoginRecord();
            this.setupCapabilitiesToken();
            this.writer.send();
            this.reader.receive();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private void setupLoginRecord() throws UtilException {
        int n = 0;
        this.writer.writeFillerBytes((byte)0, 30);
        this.writer.writeInt8(0);
        if (this.comm.debugWireProtocol) {
            UtilSnoopIndirection.doNotLogBytesInSendStream((Socket)this.comm.socket, (int)this.comm.bufferedConsumer.getPosition(), (int)62, (String)"User Name & Password Omitted Here");
        }
        n = this.writer.writeString(this.username);
        this.writer.writeFillerBytes((byte)0, 30 - n);
        this.writer.writeInt8(this.username.length());
        n = this.writer.writeString(this.password);
        this.writer.writeFillerBytes((byte)0, 30 - n);
        this.writer.writeInt8(this.password.length());
        String string = "0000016a";
        n = this.writer.writeString(string);
        this.writer.writeFillerBytes((byte)0, 30 - n);
        this.writer.writeInt8(string.length());
        this.writer.writeInt8(2);
        this.writer.writeInt8(0);
        this.writer.writeInt8(6);
        this.writer.writeInt8(4);
        this.writer.writeInt8(8);
        this.writer.writeInt8(1);
        this.writer.writeInt8(0);
        this.writer.writeInt8(0);
        this.writer.writeInt8(0);
        this.writer.writeFillerBytes((byte)0, 4);
        this.writer.writeFillerBytes((byte)0, 3);
        this.writer.writeFillerBytes((byte)0, 30);
        this.writer.writeInt8(0);
        this.writer.writeFillerBytes((byte)0, 30);
        this.writer.writeInt8(0);
        this.writer.writeFillerBytes((byte)0, 255);
        this.writer.writeInt8(0);
        byte[] byArray = new byte[]{5, 1, 0, 0};
        this.writer.writeBytes(byArray, 0, 4);
        String string2 = "JDBC";
        n = this.writer.writeString(string2);
        this.writer.writeFillerBytes((byte)0, 10 - n);
        this.writer.writeInt8(string2.length());
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        this.writer.writeBytes(byArray);
        this.writer.writeInt8(0);
        this.writer.writeInt8(12);
        this.writer.writeInt8(16);
        this.writer.writeFillerBytes((byte)0, 30);
        this.writer.writeInt8(0);
        this.writer.writeInt8(1);
        this.writer.writeFillerBytes((byte)0, 2);
        this.writer.writeInt8(0);
        this.writer.writeInt8(0);
        this.writer.writeInt8(1);
        this.writer.writeFillerBytes((byte)0, 6);
        this.writer.writeFillerBytes((byte)0, 2);
        this.writer.writeFillerBytes((byte)0, 30);
        this.writer.writeInt8(0);
        this.writer.writeInt8(0);
        String string3 = "512";
        n = this.writer.writeString(string3);
        this.writer.writeFillerBytes((byte)0, 6 - n);
        this.writer.writeInt8(string3.length());
        this.writer.writeFillerBytes((byte)0, 4);
    }

    private void setupCapabilitiesToken() throws UtilException {
        this.writer.writeInt8(-30);
        this.capabilityRequest = new byte[10];
        this.writer.writeInt16(12);
        this.writer.writeInt8(1);
        this.writer.writeInt8(10);
        this.setCapabilitiesBit(39, true);
        this.setCapabilitiesBit(40, true);
        this.setCapabilitiesBit(37, true);
        this.setCapabilitiesBit(36, true);
        this.setCapabilitiesBit(33, true);
        this.setCapabilitiesBit(34, true);
        this.setCapabilitiesBit(35, true);
        this.setCapabilitiesBit(24, true);
        this.setCapabilitiesBit(27, true);
        this.setCapabilitiesBit(19, true);
        this.setCapabilitiesBit(18, true);
        this.setCapabilitiesBit(71, true);
        this.setCapabilitiesBit(72, true);
        this.setCapabilitiesBit(13, true);
        this.setCapabilitiesBit(66, true);
        this.setCapabilitiesBit(4, true);
        this.setCapabilitiesBit(9, true);
        this.setCapabilitiesBit(59, true);
        this.writer.writeBytes(this.capabilityRequest);
    }

    void doLoginNegotiation(BaseWarnings baseWarnings) throws SQLException {
        try {
            byte by = (byte)this.reader.readUnsignedInt8();
            if (by != 101) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            short s = this.reader.readUnsignedInt8();
            short s2 = this.reader.readUnsignedInt8();
            int n = this.reader.readUnsignedInt16();
            if (n != 12) {
                String[] stringArray = new String[]{"Type " + n + " not supported."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            if (s2 != 1) {
                String[] stringArray = new String[]{"No parameters in TDS_MSG token."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            by = (byte)this.reader.readUnsignedInt8();
            if (by != -20) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            short s3 = this.reader.readInt16();
            short s4 = this.reader.readInt16();
            if (s4 != 1) {
                String[] stringArray = new String[]{s4 + " is an unexpected number of parameters."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            byte[] byArray = new byte[s3 - 2];
            this.reader.readBytes(byArray, 0, s3 - 2);
            int n2 = 6 + byArray[0];
            if (byArray[n2] != 37) {
                String[] stringArray = new String[]{"Parameter type is not TDS_VARBINARY."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            by = (byte)this.reader.readUnsignedInt8();
            if (by != -41) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            byte by2 = this.reader.readInt8();
            byte[] byArray2 = new byte[by2];
            this.reader.readBytes(byArray2, 0, (int)by2);
            by = (byte)this.reader.readUnsignedInt8();
            if (by != -3) {
                String[] stringArray = new String[]{"Token " + this.getNameForTokenType(by) + " not expected."};
                throw this.comm.exceptions.getException(7008, stringArray);
            }
            this.reader.readAndDiscardBytes(8);
            this.clearReplyChannel();
            this.comm.setMessageType(15);
            this.writer.writeInt8(101);
            this.writer.writeInt8((int)s);
            this.writer.writeInt8((int)s2);
            this.writer.writeInt16(n);
            this.writer.writeInt8(-20);
            this.writer.writeInt16((int)s3);
            this.writer.writeInt16((int)s4);
            this.writer.writeBytes(byArray, 0, s3 - 2);
            this.writer.writeInt8(-41);
            this.writer.writeInt8((int)by2);
            this.writer.writeBytes(byArray2, 0, (int)by2);
            this.writer.send();
            this.reader.receive();
            this.processReply(baseWarnings);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (by) {
                case -3: 
                case -2: 
                case -1: {
                    int n = this.reader.readUnsignedInt16();
                    int n2 = this.reader.readUnsignedInt16();
                    int n3 = this.reader.readInt32();
                    if ((n & 2) != 0) {
                        throw this.comm.exceptions.getException(7003);
                    }
                    break;
                }
                case -30: {
                    short s;
                    short s2;
                    int n = this.reader.readUnsignedInt16();
                    if (n > 0) {
                        s2 = this.reader.readUnsignedInt8();
                        s = this.reader.readUnsignedInt8();
                        if (s2 == 1) {
                            this.reader.readBytes(this.capabilityRequest, 0, (int)s);
                        } else {
                            this.reader.readBytes(this.capabilityResponse, 0, (int)s);
                        }
                        n -= 2 + s;
                    }
                    if (n > 0) {
                        s2 = this.reader.readUnsignedInt8();
                        s = this.reader.readUnsignedInt8();
                        if (s2 == 1) {
                            this.reader.readBytes(this.capabilityRequest, 0, (int)s);
                            break;
                        }
                        this.reader.readBytes(this.capabilityResponse, 0, (int)s);
                    }
                    break;
                }
                case -83: {
                    int n = this.reader.readUnsignedInt16();
                    byte by2 = this.reader.readInt8();
                    if (by2 == 6) {
                        throw this.comm.exceptions.getException(7003);
                    }
                    byte[] byArray = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    String string = this.reader.readString((int)this.reader.readInt8());
                    this.majorServerVersion = this.reader.readInt8();
                    this.minorServerVersion = this.reader.readInt8();
                    this.reader.readInt16();
                    if (by2 == 7) {
                        this.doLoginNegotiation(baseWarnings);
                    }
                    break;
                }
                default: {
                    super.processReplyToken(by, baseWarnings);
                    break;
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        return true;
    }

    protected void setCapabilitiesBit(int n, boolean bl) {
        byte by;
        byte[] byArray;
        int n2;
        if (bl) {
            n2 = 10 - n / 8 - 1;
            byArray = this.capabilityRequest;
        } else {
            n2 = 8 - n / 8 - 1;
            byArray = this.capabilityResponse;
        }
        int n3 = n % 8;
        byArray[n2] = by = (byte)(byArray[n2] | 1 << n3);
    }

    public boolean getCapabilitiesBit(int n, boolean bl) {
        byte[] byArray;
        int n2;
        if (bl) {
            n2 = 10 - n / 8 - 1;
            byArray = this.capabilityRequest;
        } else {
            n2 = 8 - n / 8 - 1;
            byArray = this.capabilityResponse;
        }
        int n3 = n % 8;
        byte by = byArray[n2];
        byte by2 = (byte)(1 << n3);
        return (by & by2) != 0;
    }
}

