/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCRequest;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

public abstract class TDSRPCExecuteRequest
extends TDSRPCRequest {
    private static String footprint = "$Revision:   3.16.1.1  $";
    protected boolean isPreparedStatement;
    protected String sql;
    private boolean prepareSubmitted;
    protected TDSRPCParameter userParamDefinitionsParam;
    protected TDSRPCParameter prepareHandleParam;
    protected TDSRPCParameter stmtParam;
    private static final int FOR_PREPARED_EXECUTE = 0;
    private static final int FOR_UNPREPARED_EXECUTE = 1;

    public TDSRPCExecuteRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, boolean bl) {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter);
        this.isPreparedStatement = bl;
        this.prepareSubmitted = false;
        this.sql = null;
        this.createRPCParameters();
    }

    public void createUserParameters(UtilVectorUnsynced utilVectorUnsynced, int n, boolean bl, int n2) {
        this.baseParamSets = utilVectorUnsynced;
        this.maxPrecision = n;
        this.sendStringParametersAsUnicode = bl;
        this.receiveStringParameterType = n2;
        if (utilVectorUnsynced == null) {
            return;
        }
        BaseParameters baseParameters = (BaseParameters)utilVectorUnsynced.get(0);
        int n3 = baseParameters.count();
        int n4 = 1;
        while (n4 <= n3) {
            this.addUserParameter(new TDSRPCParameter(this.conn.getTDSVersion(), n, this.conn.exceptions, this.conn.connection));
            ++n4;
        }
    }

    public final void setSQL(String string) {
        this.sql = string;
    }

    protected void createRPCParameters() {
        this.stmtParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        this.prepareHandleParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        this.userParamDefinitionsParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
    }

    public void reset() {
        super.reset();
        this.prepareSubmitted = false;
    }

    protected void doPrepExec(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        this.submitPrepare(sQLServerImplStatement, baseWarnings);
        this.submitExecute(sQLServerImplStatement, baseWarnings);
    }

    protected abstract void setupExecute(BaseWarnings var1) throws SQLException;

    protected abstract void setupUnpreparedExecute(BaseWarnings var1) throws SQLException;

    protected abstract void submitPrepare(SQLServerImplStatement var1, BaseWarnings var2) throws SQLException;

    protected abstract void submitPrepExec(SQLServerImplStatement var1, BaseWarnings var2) throws SQLException;

    protected abstract void submitExecute(SQLServerImplStatement var1, BaseWarnings var2) throws SQLException;

    protected abstract void submitUnpreparedExecute(SQLServerImplStatement var1, BaseWarnings var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        String string = null;
        if (this.prepareSubmitted && this.prepareHandleParam.data.isNull) {
            this.readPrepareHandle(baseWarnings);
        }
        if (this.baseParamSets != null && this.baseParamSets.size() > 1) {
            SQLException sQLException = null;
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                int n = this.baseParamSets.size();
                int n2 = 0;
                while (n2 < n) {
                    BaseParameters baseParameters = (BaseParameters)this.baseParamSets.get(n2);
                    try {
                        this.processUserParameters(baseParameters);
                    }
                    catch (SQLException sQLException2) {
                        sQLException = sQLException2;
                        break;
                    }
                    if (this.prepareHandleParam.data.isNull) {
                        string = this.createParameterFormatString(0);
                        this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
                        this.submitPrepare(sQLServerImplStatement, baseWarnings);
                        this.reset();
                        this.setupExecute(baseWarnings);
                    } else if (this.hasParmameterFormatStringChangedSincePrepare()) {
                        string = this.createParameterFormatString(1);
                        this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
                        this.setupUnpreparedExecute(baseWarnings);
                    } else {
                        this.setupExecute(baseWarnings);
                    }
                    this.encodeRPCCall(n2 == 0);
                    ++n2;
                }
                if (n2 > 0) {
                    this.submitRequest(sQLServerImplStatement);
                }
            }
            if (sQLException != null) {
                throw sQLException;
            }
        } else if (this.isPreparedStatement) {
            if (this.baseParamSets != null) {
                this.processUserParameters((BaseParameters)this.baseParamSets.get(0));
            }
            if (this.prepareHandleParam.data.isNull) {
                string = this.createParameterFormatString(0);
                this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
                this.doPrepExec(sQLServerImplStatement, baseWarnings);
                this.prepareSubmitted = true;
            } else if (this.hasParmameterFormatStringChangedSincePrepare()) {
                string = this.createParameterFormatString(1);
                this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
                this.submitUnpreparedExecute(sQLServerImplStatement, baseWarnings);
            } else {
                this.submitExecute(sQLServerImplStatement, baseWarnings);
            }
        } else {
            this.submitUnpreparedExecute(sQLServerImplStatement, baseWarnings);
        }
    }

    private void processUserParameters(BaseParameters baseParameters) throws SQLException {
        if (baseParameters == null) {
            return;
        }
        int n = baseParameters.count();
        TDSRPCParameter tDSRPCParameter = null;
        int n2 = 1;
        while (n2 <= n) {
            tDSRPCParameter = (TDSRPCParameter)this.userParameters.get(n2 - 1);
            tDSRPCParameter.initializeUserParam(n2, baseParameters, this.sendStringParametersAsUnicode, this.receiveStringParameterType);
            ++n2;
        }
    }

    private boolean hasParmameterFormatStringChangedSincePrepare() {
        if (this.prepareHandleParam.data.isNull) {
            return true;
        }
        int n = this.userParameters.size();
        int n2 = 1;
        while (n2 <= n) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.userParameters.get(n2 - 1);
            if (tDSRPCParameter.hasStateChanged()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String createParameterFormatString(int n) {
        int n2 = this.userParameters.size();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 1;
        while (n3 <= n2) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.userParameters.get(n3 - 1);
            if (n == 0) {
                tDSRPCParameter.recordState();
            }
            if (n3 != 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(tDSRPCParameter.paramName);
            stringBuffer.append(" ");
            stringBuffer.append(tDSRPCParameter.nativeTypeName);
            ++n3;
        }
        return stringBuffer.toString();
    }

    private void readPrepareHandle(BaseWarnings baseWarnings) throws SQLException {
        while (this.resultType != 1) {
            this.completeRowProcessing(baseWarnings);
            this.processReply(1, baseWarnings);
        }
    }
}

