/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.cache;

import com.metamatrix.connector.xml.cache.ExecutionRecord;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.cache.Record;
import com.metamatrix.data.api.ConnectorLogger;
import java.util.HashMap;
import java.util.Map;

public class RequestPartRecord
implements Record {
    Record parent;
    String partID;
    Map executionRecords = new HashMap();

    public RequestPartRecord(Record parent, String partID, String executionID, String sourceRequestID, String cacheKey, ConnectorLogger logger) {
        this.partID = partID;
        this.parent = parent;
        this.addExecutionRecord(executionID, sourceRequestID, cacheKey, logger);
    }

    public void addExecutionRecord(String executionID, String sourceRequestID, String cacheKey, ConnectorLogger logger) {
        ExecutionRecord execution = (ExecutionRecord)this.executionRecords.get(executionID);
        if (null == execution) {
            logger.logTrace("Creating new ExecutionRecord for executionID " + executionID);
            execution = new ExecutionRecord(this, executionID, sourceRequestID, cacheKey);
            this.executionRecords.put(executionID, execution);
        } else {
            logger.logTrace("Adding CacheRecord for executionID " + executionID);
            execution.addCacheRecord(sourceRequestID, cacheKey);
        }
    }

    public IDocumentCache getCache() {
        return this.parent.getCache();
    }

    public String getID() {
        return this.parent.getID() + this.partID;
    }

    public void deleteExecutionRecords(String executionID, ConnectorLogger logger) {
        ExecutionRecord execution = (ExecutionRecord)this.executionRecords.get(executionID);
        if (null != execution) {
            logger.logTrace("Deleting cache items for ExecutionRecord " + executionID);
            execution.deleteCacheItems(logger);
        }
    }
}

