/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.MappingSourceNode;
import com.metamatrix.query.mapping.xml.MappingVisitor;
import com.metamatrix.query.mapping.xml.Navigator;
import com.metamatrix.query.mapping.xml.ResultSetInfo;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.optimizer.xml.QueryUtil;
import com.metamatrix.query.optimizer.xml.XMLPlannerEnvironment;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SourceNodePlannerVisitor
extends MappingVisitor {
    XMLPlannerEnvironment planEnv;

    public SourceNodePlannerVisitor(XMLPlannerEnvironment planEnv) {
        this.planEnv = planEnv;
    }

    public void visit(MappingSourceNode sourceNode) {
        try {
            String groupName = sourceNode.getResultName();
            GroupSymbol groupSymbol = QueryUtil.createResolvedGroup((String)groupName, (QueryMetadataInterface)this.planEnv.getGlobalMetadata());
            GroupSymbol newGroupSymbol = this.createAlternateGroup(groupSymbol, sourceNode);
            String newGroup = newGroupSymbol.getName();
            ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
            Query baseQuery = QueryUtil.wrapQuery((FromClause)new UnaryFromClause(new GroupSymbol(newGroup)), (String)newGroup);
            baseQuery.getSelect().clearSymbols();
            Iterator i = ResolverUtil.resolveElementsInGroup(groupSymbol, (QueryMetadataInterface)this.planEnv.getGlobalMetadata()).iterator();
            while (i.hasNext()) {
                SingleElementSymbol ses = (SingleElementSymbol)i.next();
                baseQuery.getSelect().addSymbol((SelectSymbol)new ElementSymbol(newGroup + "." + ses.getShortName()));
            }
            rsInfo.setCommand((Command)baseQuery);
            QueryNode modifiedNode = QueryUtil.getQueryNode((String)newGroup, (QueryMetadataInterface)this.planEnv.getGlobalMetadata());
            Command command = QueryUtil.getQuery((QueryNode)modifiedNode);
            MappingSourceNode parent = sourceNode.getParentSourceNode();
            rsInfo.setInputSet(!ReferenceCollectorVisitor.getReferences((LanguageObject)command).isEmpty());
            Assertion.assertTrue((parent != null || parent == null && !rsInfo.hasInputSet() ? 1 : 0) != 0);
            if (!(rsInfo.hasInputSet() && this.canRaiseInputset(command) && this.areBindingsOnlyToNode(modifiedNode, parent))) {
                return;
            }
            Query transformationQuery = (Query)command;
            QueryUtil.resolveQuery((Command)transformationQuery, (TempMetadataAdapter)this.planEnv.getGlobalMetadata());
            Criteria criteria = transformationQuery.getCriteria();
            Criteria nonInputsetCriteria = null;
            Criteria inputSetCriteria = null;
            Iterator i2 = Criteria.separateCriteriaByAnd((Criteria)criteria).iterator();
            while (i2.hasNext()) {
                Criteria conjunct = (Criteria)i2.next();
                List references = ReferenceCollectorVisitor.getReferences((LanguageObject)conjunct);
                if (references.isEmpty()) {
                    nonInputsetCriteria = Criteria.combineCriteria(nonInputsetCriteria, (Criteria)conjunct);
                    continue;
                }
                inputSetCriteria = Criteria.combineCriteria(inputSetCriteria, (Criteria)conjunct);
            }
            if (inputSetCriteria == null) {
                return;
            }
            transformationQuery.setCriteria(nonInputsetCriteria);
            boolean addedProjectedSymbol = this.convertCriteria(newGroupSymbol, transformationQuery, inputSetCriteria, this.planEnv.getGlobalMetadata(), sourceNode.getSymbolMap());
            if (addedProjectedSymbol && transformationQuery.getSelect().isDistinct()) {
                transformationQuery.getSelect().setDistinct(false);
                baseQuery.getSelect().setDistinct(true);
            }
            String inlineViewName = this.planEnv.getAliasName(newGroup);
            transformationQuery = QueryUtil.wrapQuery((FromClause)new SubqueryFromClause(inlineViewName, (Command)transformationQuery), (String)inlineViewName);
            QueryNode relationalNode = new QueryNode(newGroup, SQLStringVisitor.getSQLString((LanguageObject)transformationQuery));
            this.planEnv.addQueryNodeToMetadata(newGroupSymbol.getMetadataID(), relationalNode);
            QueryUtil.handleBindings((LanguageObject)inputSetCriteria, (QueryNode)modifiedNode, (XMLPlannerEnvironment)this.planEnv);
            baseQuery.setCriteria(inputSetCriteria);
            rsInfo.setCriteriaRaised(true);
        }
        catch (Exception e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private boolean areBindingsOnlyToNode(QueryNode modifiedNode, MappingSourceNode sourceNode) throws MetaMatrixComponentException {
        List bindings = QueryUtil.parseBindings((QueryNode)modifiedNode, (XMLPlannerEnvironment)this.planEnv);
        String nodeStr = (sourceNode.getActualResultSetName() + ".").toUpperCase();
        Iterator i = bindings.iterator();
        while (i.hasNext()) {
            ElementSymbol binding = (ElementSymbol)i.next();
            if (binding.getCanonicalName().startsWith(nodeStr)) continue;
            return false;
        }
        return true;
    }

    static String getNewName(String groupName, TempMetadataStore store) {
        int index = 1;
        String newGroup = null;
        do {
            newGroup = (groupName + "_" + index++).toUpperCase();
        } while (store.getData().containsKey(newGroup));
        return newGroup;
    }

    private GroupSymbol createAlternateGroup(GroupSymbol oldSymbol, MappingSourceNode sourceNode) throws QueryMetadataException, MetaMatrixComponentException, QueryResolverException, QueryPlannerException {
        List elements = ResolverUtil.resolveElementsInGroup(oldSymbol, (QueryMetadataInterface)this.planEnv.getGlobalMetadata());
        TempMetadataStore store = this.planEnv.getGlobalMetadata().getMetadataStore();
        String newGroup = SourceNodePlannerVisitor.getNewName(oldSymbol.getName(), store);
        GroupSymbol newGroupSymbol = new GroupSymbol(newGroup);
        newGroupSymbol.setMetadataID(store.addTempGroup(newGroup, elements));
        sourceNode.setSymbolMap(QueryUtil.createSymbolMap((GroupSymbol)oldSymbol, (String)newGroup, (Collection)elements));
        QueryNode oldQueryNode = QueryUtil.getQueryNode((String)oldSymbol.getName(), (QueryMetadataInterface)this.planEnv.getGlobalMetadata());
        QueryNode modifiedNode = new QueryNode(newGroup, oldQueryNode.getQuery());
        SourceNodePlannerVisitor.mapBindings(sourceNode, oldQueryNode, modifiedNode);
        this.planEnv.addQueryNodeToMetadata(newGroupSymbol.getMetadataID(), modifiedNode);
        return newGroupSymbol;
    }

    static void mapBindings(MappingSourceNode sourceNode, QueryNode oldQueryNode, QueryNode modifiedNode) {
        if (oldQueryNode.getBindings() != null) {
            ArrayList<String> bindings = new ArrayList<String>();
            Iterator i = oldQueryNode.getBindings().iterator();
            while (i.hasNext()) {
                String binding = (String)i.next();
                bindings.add(sourceNode.getMappedSymbol(new ElementSymbol(binding)).getName());
            }
            modifiedNode.setBindings(bindings);
        }
    }

    private boolean canRaiseInputset(Command command) {
        if (!(command instanceof Query)) {
            return false;
        }
        Query query = (Query)command;
        Criteria crit = query.getCriteria();
        if (crit != null && (query.getGroupBy() != null || query.getHaving() != null || query.getLimit() != null)) {
            return false;
        }
        query.setCriteria(null);
        query.setOrderBy(null);
        List references = ReferenceCollectorVisitor.getReferences((LanguageObject)query);
        query.setCriteria(crit);
        return references.isEmpty();
    }

    private boolean convertCriteria(GroupSymbol newGroupSymbol, Query transformationQuery, Criteria criteria, TempMetadataAdapter metadata, Map symbolMap) throws QueryMetadataException, MetaMatrixComponentException {
        String groupName = newGroupSymbol.getName();
        Collection elementsInCriteria = ElementCollectorVisitor.getElements((LanguageObject)criteria, (boolean)true);
        HashMap<ElementSymbol, ElementSymbol> mappedElements = new HashMap<ElementSymbol, ElementSymbol>();
        List projectedSymbols = transformationQuery.getProjectedSymbols();
        boolean addedProjectedSymbol = false;
        Iterator i = elementsInCriteria.iterator();
        while (i.hasNext()) {
            ElementSymbol symbol = (ElementSymbol)i.next();
            if (projectedSymbols.contains(symbol)) {
                mappedElements.put(symbol, new ElementSymbol(groupName + "." + symbol.getShortName()));
                continue;
            }
            AliasSymbol alias = this.getMachingAlias(projectedSymbols, symbol);
            if (alias != null) {
                mappedElements.put(symbol, new ElementSymbol(groupName + "." + alias.getShortName()));
                continue;
            }
            String name = SourceNodePlannerVisitor.getNewSymbolName(newGroupSymbol.getName(), symbol, symbolMap);
            AliasSymbol selectSymbol = new AliasSymbol(name, (SingleElementSymbol)symbol);
            transformationQuery.getSelect().addSymbol((SelectSymbol)selectSymbol);
            addedProjectedSymbol = true;
            metadata.getMetadataStore().addElementSymbolToTempGroup(newGroupSymbol.getName(), (SingleElementSymbol)selectSymbol);
            ElementSymbol upperSymbol = new ElementSymbol(groupName + "." + selectSymbol.getShortName());
            mappedElements.put(symbol, upperSymbol);
            symbolMap.put(upperSymbol, upperSymbol);
        }
        ExpressionMappingVisitor.mapExpressions((LanguageObject)criteria, mappedElements);
        return addedProjectedSymbol;
    }

    static String getNewSymbolName(String newGroupName, ElementSymbol elementSymbol, Map symbolMap) {
        int index = 1;
        String newSymbolName = elementSymbol.getShortName();
        while (symbolMap.values().contains(new ElementSymbol(newGroupName + "." + newSymbolName))) {
            newSymbolName = elementSymbol.getShortName() + "_" + index++;
        }
        return newSymbolName;
    }

    private AliasSymbol getMachingAlias(List elementsInGroup, ElementSymbol symbol) {
        Iterator i = elementsInGroup.iterator();
        while (i.hasNext()) {
            AliasSymbol alias;
            SingleElementSymbol element = (SingleElementSymbol)i.next();
            if (!(element instanceof AliasSymbol) || !(alias = (AliasSymbol)element).getSymbol().equals((Object)symbol)) continue;
            return alias;
        }
        return null;
    }

    public static MappingDocument raiseInputSet(MappingDocument doc, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        SourceNodePlannerVisitor real = new SourceNodePlannerVisitor(planEnv);
        SourceNodePlannerVisitor.planWalk(doc, real);
        return doc;
    }

    private static void planWalk(MappingDocument doc, MappingVisitor visitor) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        try {
            Navigator walker = new Navigator(true, visitor);
            doc.acceptVisitor((MappingVisitor)walker);
        }
        catch (MetaMatrixRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)e.getCause();
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)e.getCause();
            }
            if (e.getCause() instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)e.getCause();
            }
            throw e;
        }
    }
}

