/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.VDBDeployer;
import org.teiid.jboss.VDBOperations;
import org.teiid.vdb.runtime.VDBKey;

class AssignDataSource
extends VDBOperations {
    public AssignDataSource() {
        super("assign-datasource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeOperation(OperationContext context, RuntimeVDB vdb, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.MODEL_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.MODEL_NAME.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.SOURCE_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.SOURCE_NAME.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.TRANSLATOR_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.TRANSLATOR_NAME.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.DS_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.DS_NAME.getName() + ".missing")));
        }
        String modelName = operation.get(OperationsConstants.MODEL_NAME.getName()).asString();
        String sourceName = operation.get(OperationsConstants.SOURCE_NAME.getName()).asString();
        String translatorName = operation.get(OperationsConstants.TRANSLATOR_NAME.getName()).asString();
        String dsName = operation.get(OperationsConstants.DS_NAME.getName()).asString();
        try {
            VDBMetaData vDBMetaData = vdb.getVdb();
            synchronized (vDBMetaData) {
                RuntimeVDB.ReplaceResult rr = vdb.assignDatasource(modelName, sourceName, translatorName, dsName);
                if (rr.isNew) {
                    VDBDeployer.addDataSourceListener(context.getServiceTarget(), new VDBKey(vdb.getVdb().getName(), vdb.getVdb().getVersion()), dsName);
                }
                if (rr.removedDs != null) {
                    ServiceName serviceName;
                    ServiceRegistry registry = context.getServiceRegistry(true);
                    try {
                        serviceName = TeiidServiceNames.dsListenerServiceName(vdb.getVdb().getName(), vdb.getVdb().getVersion(), rr.removedDs);
                    }
                    catch (TeiidServiceNames.InvalidServiceNameException e) {
                        return;
                    }
                    ServiceController controller = registry.getService(serviceName);
                    if (controller != null) {
                        context.removeService(serviceName);
                    }
                }
            }
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        super.describeParameters(builder);
        builder.addParameter((AttributeDefinition)OperationsConstants.MODEL_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.SOURCE_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.TRANSLATOR_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.DS_NAME);
    }
}

