/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.ConfigurationException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    static Iterator<Throwable> getChildrenIterator(Throwable e) {
        return new NestedExceptionIterator(e);
    }

    public static String getLinkedMessagesVerbose(Throwable exception) {
        return ExceptionUtil.getLinkedMessagesVerbose(exception, 0);
    }

    static String getLinkedMessagesVerbose(Throwable exception, int level) {
        if (exception != null) {
            StringBuffer buf = new StringBuffer();
            String lastMessage = ExceptionUtil.appendMessage("", buf, null, exception);
            Iterator<Throwable> children = ExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                ++level;
                exception = children.next();
                lastMessage = ExceptionUtil.appendMessage("->", buf, lastMessage, exception);
            }
            return buf.toString();
        }
        return "";
    }

    private static final String appendMessage(String prefix, StringBuffer buffer, String lastMessage, Throwable exception) {
        String message = exception.getMessage();
        buffer.append(prefix);
        buffer.append(exception.getClass().getSimpleName());
        if (message != null && !message.equals(lastMessage)) {
            buffer.append('-');
            buffer.append(message);
        }
        return message;
    }

    public static class NestedExceptionIterator
    implements Iterator<Throwable> {
        Throwable exception;
        Throwable child;

        public NestedExceptionIterator(Throwable e) {
            this.exception = e;
        }

        @Override
        public boolean hasNext() {
            this.check();
            return this.child != null;
        }

        @Override
        public Throwable next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.exception = this.child;
            this.child = null;
            return this.exception;
        }

        private void check() {
            if (this.child == null) {
                if (this.exception instanceof ConfigurationException) {
                    ConfigurationException e = (ConfigurationException)this.exception;
                    this.child = e.getRootCause();
                } else if (this.exception instanceof SQLException) {
                    SQLException e = (SQLException)this.exception;
                    this.child = e.getNextException();
                }
                if (this.child == null) {
                    this.child = this.exception.getCause();
                }
                if (this.child == this.exception) {
                    this.child = null;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

