/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.metadata;

import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.resource.adapter.google.metadata.SpreadsheetInfo;
import org.teiid.resource.adapter.google.metadata.Worksheet;

public class MetadataProcessor {
    MetadataFactory metadataFactory;
    SpreadsheetInfo spreadsheetMetadata;

    public MetadataProcessor(MetadataFactory metadataFactory, SpreadsheetInfo metadata) {
        this.metadataFactory = metadataFactory;
        this.spreadsheetMetadata = metadata;
    }

    public void processMetadata() {
        for (Worksheet worksheet : this.spreadsheetMetadata.getWorksheets()) {
            this.addTable(worksheet);
        }
    }

    private void addTable(Worksheet worksheet) {
        if (worksheet.getColumnCount() == 0) {
            return;
        }
        Table table = this.metadataFactory.addTable(worksheet.getName());
        table.setNameInSource(worksheet.getName());
        this.addColumnsToTable(table, worksheet);
    }

    private void addColumnsToTable(Table table, Worksheet worksheet) {
        for (org.teiid.resource.adapter.google.metadata.Column column : worksheet.getColumns()) {
            String type = null;
            switch (column.getDataType()) {
                case DATE: {
                    type = "date";
                    break;
                }
                case BOOLEAN: {
                    type = "boolean";
                    break;
                }
                case DATETIME: {
                    type = "timestamp";
                    break;
                }
                case NUMBER: {
                    type = "double";
                    break;
                }
                case TIMEOFDAY: {
                    type = "time";
                    break;
                }
                default: {
                    type = "string";
                }
            }
            Column c = this.metadataFactory.addColumn(column.getLabel() != null ? column.getLabel() : column.getAlphaName(), type, (ColumnSet)table);
            c.setNameInSource(column.getAlphaName());
            c.setNativeType(column.getDataType().name());
        }
    }
}

