/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.plan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Annotation
implements Externalizable {
    public static final String MATERIALIZED_VIEW = "Materialized View";
    public static final String CACHED_PROCEDURE = "Cached Procedure";
    public static final String HINTS = "Hints";
    public static final String RELATIONAL_PLANNER = "Relational Planner";
    private String category;
    private String annotation;
    private String resolution;
    private Priority priority = Priority.LOW;

    public Annotation() {
    }

    public Annotation(String category, String annotation, String resolution, Priority priority) {
        this.category = category;
        this.annotation = annotation;
        this.resolution = resolution;
        this.priority = priority;
    }

    public String getCategory() {
        return this.category;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getResolution() {
        return this.resolution;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String toString() {
        return "QueryAnnotation<" + this.getCategory() + ", " + (Object)((Object)this.getPriority()) + "," + this.getAnnotation() + "," + this.getResolution() + ">";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.annotation = (String)in.readObject();
        this.category = (String)in.readObject();
        this.resolution = (String)in.readObject();
        this.priority = Priority.values()[in.readByte()];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.annotation);
        out.writeObject(this.category);
        out.writeObject(this.resolution);
        out.writeByte(this.priority.ordinal());
    }

    public static enum Priority {
        LOW,
        MEDIUM,
        HIGH;

    }
}

